/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.tag;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.GetTagResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.user.BatchTagModel;
import io.rong.models.user.GetTagModel;
import io.rong.models.user.TagModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Tag {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/tag";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Tag(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public Result set(TagModel tag) throws Exception {
        String message = CommonUtil.checkFiled(tag, PATH, "setTag");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/tag/set.json", "application/json");
        HttpUtil.setBodyParameter(tag.toString(), conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "setTag", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result batchSet(BatchTagModel batchTag) throws Exception {
        String message = CommonUtil.checkFiled(batchTag, PATH, "batchSetTag");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/tag/batch/set.json", "application/json");
        HttpUtil.setBodyParameter(batchTag.toString(), conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "batchSetTag", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public GetTagResult get(GetTagModel getTag) throws Exception {
        String message = CommonUtil.checkFiled(getTag, PATH, "getTag");
        if (null != message) {
            return (GetTagResult)GsonUtil.fromJson(message, GetTagResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < getTag.getUserIds().length; ++i) {
            String userId = getTag.getUserIds()[i];
            if (null == userId) continue;
            sb.append("&userIds=").append(URLEncoder.encode(userId, UTF8));
        }
        if (sb.indexOf("&") == 0) {
            sb.deleteCharAt(0);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/tags/get.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(sb, conn);
        return (GetTagResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getTag", HttpUtil.returnResult(conn)), GetTagResult.class);
    }
}

