/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.contentcensor;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.contentcensor.ContentCensorConsts;
import com.baidu.aip.contentcensor.EImgType;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.ImageUtil;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AipContentCensor
extends BaseClient {
    public AipContentCensor(String appId, String aipKey, String aipToken) {
        super(appId, aipKey, aipToken);
    }

    public JSONObject antiPorn(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.antiPorn(imgData);
        }
        catch (IOException e) {
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject antiPorn(byte[] imgData) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/antiporn/v1/detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject antiPornGif(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.antiPornGif(imgData);
        }
        catch (IOException e) {
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject antiPornGif(byte[] imgData) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkImgFormat(imgData, "gif");
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/antiporn/v1/detect_gif");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject antiTerror(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.antiTerror(imgData);
        }
        catch (IOException e) {
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject antiTerror(byte[] imgData) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/antiterror/v1/detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject imageCensorComb(String imgPath, EImgType type, List<String> scenes, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            try {
                byte[] imgData = Util.readFileByBytes(imgPath);
                return this.imageCensorComb(imgData, scenes, options);
            }
            catch (IOException e) {
                return AipError.IMAGE_READ_ERROR.toJsonResult();
            }
        }
        AipRequest request = new AipRequest();
        request.addBody("imgUrl", imgPath);
        return this.imageCensorCombHelper(request, scenes, options);
    }

    public JSONObject imageCensorComb(byte[] imgData, List<String> scenes, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        return this.imageCensorCombHelper(request, scenes, options);
    }

    private JSONObject imageCensorCombHelper(AipRequest request, List<String> scenes, HashMap<String, String> options) {
        this.preOperation(request);
        JSONArray obj = new JSONArray();
        for (String string : scenes) {
            obj.put((Object)string);
        }
        request.addBody("scenes", obj);
        if (options != null) {
            for (Map.Entry entry : options.entrySet()) {
                request.addBody((String)entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/api/v1/solution/direct/img_censor");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addHeader("Content-Type", "application/json");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceAudit(List<String> imgPaths, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            try {
                byte[][] imgData = new byte[imgPaths.size()][];
                int idx = 0;
                for (String path : imgPaths) {
                    imgData[idx] = Util.readFileByBytes(path);
                    ++idx;
                }
                return this.faceAudit(imgData, options);
            }
            catch (IOException e) {
                e.printStackTrace();
                return AipError.IMAGE_READ_ERROR.toJsonResult();
            }
        }
        AipRequest request = new AipRequest();
        request.addBody("imgUrls", Util.mkString(imgPaths.iterator(), ','));
        return this.faceAuditHelper(request, options);
    }

    public JSONObject faceAudit(byte[][] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        ArrayList<String> buffer = new ArrayList<String>();
        for (byte[] data : imgData) {
            String base64Str = Base64Util.encode(data);
            buffer.add(base64Str);
        }
        String imgDataAll = Util.mkString(buffer.iterator(), ',');
        request.addBody("images", imgDataAll);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        return this.faceAuditHelper(request, options);
    }

    private JSONObject faceAuditHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/face_audit");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject report(JSONArray reportData) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("feedback", reportData);
        request.setUri("https://aip.baidubce.com/rpc/2.0/feedback/v1/report");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addHeader("Content-Type", "application/json");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject imageCensorUserDefined(String image, EImgType type, HashMap<String, String> options) {
        if (type == EImgType.FILE) {
            try {
                byte[] imgData = Util.readFileByBytes(image);
                return this.imageCensorUserDefined(imgData, options);
            }
            catch (IOException e) {
                return AipError.IMAGE_READ_ERROR.toJsonResult();
            }
        }
        AipRequest request = new AipRequest();
        request.addBody("imgUrl", image);
        return this.imageCensorUserDefinedHelper(request, options);
    }

    public JSONObject imageCensorUserDefined(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        return this.imageCensorUserDefinedHelper(request, options);
    }

    private JSONObject imageCensorUserDefinedHelper(AipRequest request, HashMap<String, String> options) {
        this.preOperation(request);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/img_censor/user_defined");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject antiSpam(String content, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("content", content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/antispam/v2/spam");
        this.postOperation(request);
        return this.requestServer(request);
    }

    private JSONObject checkParam(byte[] imgData) {
        String format = ImageUtil.getImageFormatByBytes(imgData);
        if (!ContentCensorConsts.ANTIPORN_SUPPORT_IMAGE_FORMAT.contains(format)) {
            return AipError.UNSUPPORTED_IMAGE_FORMAT_ERROR.toJsonResult();
        }
        return AipError.SUCCESS.toJsonResult();
    }

    private JSONObject checkImgFormat(byte[] imgData, String format) {
        String realFormat = ImageUtil.getImageFormatByBytes(imgData);
        if (realFormat.equals(format)) {
            return AipError.SUCCESS.toJsonResult();
        }
        return AipError.UNSUPPORTED_IMAGE_FORMAT_ERROR.toJsonResult();
    }
}

