/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.speech;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipHttpClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.AipResponse;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.speech.TtsResponse;
import com.baidu.aip.util.AipClientConst;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.SignUtil;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AipSpeech
extends BaseClient {
    public AipSpeech(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject asr(String path, String format, int rate, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(path);
            return this.asr(imgData, format, rate, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject asr(byte[] data, String format, int rate, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (this.isBceKey.get()) {
            return Util.getGeneralError(AipClientConst.OPENAPI_NO_ACCESS_ERROR_CODE, "No permission to access data");
        }
        String base64Content = Base64Util.encode(data);
        request.addBody("speech", base64Content);
        request.addBody("format", format);
        request.addBody("rate", rate);
        request.addBody("channel", 1);
        String cuid = SignUtil.md5(this.accessToken, "UTF-8");
        request.addBody("cuid", cuid);
        request.addBody("token", this.accessToken);
        request.addBody("len", data.length);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("http://vop.baidu.com/server_api");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addHeader("Content-Type", "application/json");
        return this.requestServer(request);
    }

    public JSONObject asr(String url, String callback, String format, int rate, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (this.isBceKey.get()) {
            return Util.getGeneralError(AipClientConst.OPENAPI_NO_ACCESS_ERROR_CODE, "No permission to access data");
        }
        request.addBody("url", url);
        request.addBody("format", format);
        request.addBody("rate", rate);
        request.addBody("channel", 1);
        String cuid = SignUtil.md5(this.accessToken, "UTF-8");
        request.addBody("cuid", cuid);
        request.addBody("token", this.accessToken);
        request.addBody("callback", callback);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("http://vop.baidu.com/server_api");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addHeader("Content-Type", "application/json");
        return this.requestServer(request);
    }

    public TtsResponse synthesis(String text, String lang, int ctp, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (this.isBceKey.get()) {
            TtsResponse response = new TtsResponse();
            JSONObject msg = Util.getGeneralError(AipClientConst.OPENAPI_NO_ACCESS_ERROR_CODE, "No permission to access data");
            response.setResult(msg);
            return response;
        }
        request.addBody("tex", text);
        request.addBody("lan", lang);
        request.addBody("tok", this.accessToken);
        request.addBody("ctp", ctp);
        String cuid = SignUtil.md5(this.accessToken, "UTF-8");
        request.addBody("cuid", cuid);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("http://tsn.baidu.com/text2audio");
        TtsResponse response = new TtsResponse();
        AipResponse res = AipHttpClient.post(request);
        if (res == null) {
            response.setResult(Util.getGeneralError(-1, "null response from server"));
            return response;
        }
        Map<String, List<String>> header = res.getHeader();
        if (header.containsKey("content-type")) {
            String contentType = res.getHeader().get("content-type").get(0);
            if (contentType.contains("json")) {
                String data = res.getBodyStr();
                JSONObject json = new JSONObject(data);
                response.setResult(json);
            } else {
                byte[] binData = res.getBody();
                response.setData(binData);
            }
        } else {
            LOGGER.error("synthesis get no content-type in header: " + header);
            LOGGER.info("synthesis response status: " + res.getStatus());
            try {
                JSONObject json = new JSONObject(res.getBodyStr());
                response.setResult(json);
            }
            catch (JSONException e) {
                response.setData(res.getBody());
            }
        }
        return response;
    }
}

