/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.spi.DbmsDialect;
import java.util.ArrayList;
import java.util.List;

public class DefaultReturningResult<Z>
implements ReturningResult<Z> {
    private final List<Z> resultList;
    private final int updateCount;
    private final DbmsDialect dbmsDialect;

    public DefaultReturningResult(List<Z> resultList, int updateCount, DbmsDialect dbmsDialect) {
        this.resultList = resultList;
        this.updateCount = updateCount;
        this.dbmsDialect = dbmsDialect;
    }

    public DefaultReturningResult(List<Object[]> originalResultList, int updateCount, DbmsDialect dbmsDialect, ReturningObjectBuilder<Z> objectBuilder) {
        this.updateCount = updateCount;
        this.dbmsDialect = dbmsDialect;
        if (objectBuilder != null) {
            ArrayList<Object> resultList = new ArrayList<Object>(originalResultList.size());
            for (Object[] element : originalResultList) {
                resultList.add(objectBuilder.build(element));
            }
            this.resultList = objectBuilder.buildList(resultList);
        } else {
            this.resultList = originalResultList;
        }
    }

    public Z getLastResult() {
        return this.resultList.get(this.resultList.size() - 1);
    }

    public List<Z> getResultList() {
        if (this.dbmsDialect.supportsReturningAllGeneratedKeys()) {
            return this.resultList;
        }
        throw new UnsupportedOperationException("The database does not support returning all generated keys!");
    }

    public int getUpdateCount() {
        return this.updateCount;
    }
}

