/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import jakarta.persistence.FetchType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class EntitySelectResolveVisitor
extends VisitorAdapter {
    private final EntityMetamodel m;
    private final JpaProvider jpaProvider;
    private final Set<PathExpression> pathExpressions;
    private JoinNode rootNode;

    public EntitySelectResolveVisitor(EntityMetamodel m, JpaProvider jpaProvider, Set<PathExpression> pathExpressions) {
        this.m = m;
        this.jpaProvider = jpaProvider;
        this.pathExpressions = pathExpressions;
    }

    public JoinNode getRootNode() {
        return this.rootNode;
    }

    public void visit(FunctionExpression expression) {
    }

    public void visit(PathExpression expression) {
        if (expression.getField() == null) {
            this.rootNode = (JoinNode)expression.getBaseNode();
            if (this.rootNode == null) {
                return;
            }
            EntityType entityType = this.m.getEntity(this.rootNode.getJavaType());
            if (entityType == null) {
                return;
            }
            ExtendedManagedType extendedManagedType = (ExtendedManagedType)this.m.getManagedType(ExtendedManagedType.class, (ManagedType)entityType);
            Set<Object> attributePaths = this.rootNode.getValuesIdNames() != null && !this.rootNode.getValuesIdNames().isEmpty() ? this.rootNode.getValuesIdNames() : Collections.emptySet();
            Map ownedSingularAttributes = extendedManagedType.getOwnedSingularAttributes();
            Collection<String> propertyPaths = JpaUtils.getEmbeddedPropertyPaths(ownedSingularAttributes, null, this.jpaProvider.needsElementCollectionIdCutoff(), true);
            for (String propertyPath : propertyPaths) {
                if (!attributePaths.isEmpty() && !attributePaths.contains(propertyPath)) continue;
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)ownedSingularAttributes.get(propertyPath);
                Attribute attr = extendedAttribute.getAttribute();
                boolean resolve = false;
                if (JpaMetamodelUtils.isAssociation((Attribute)attr) && !attr.isCollection()) {
                    resolve = true;
                } else if (ExpressionUtils.getFetchType(attr) == FetchType.EAGER) {
                    if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                        throw new UnsupportedOperationException("Eager element collections are not supported");
                    }
                    resolve = true;
                }
                if (!resolve) continue;
                ArrayList<PropertyExpression> paths = new ArrayList<PropertyExpression>(expression.getExpressions().size() + 1);
                paths.addAll(expression.getExpressions());
                for (Attribute attribute : extendedAttribute.getAttributePath()) {
                    paths.add(new PropertyExpression(attribute.getName()));
                }
                PathExpression attrPath = new PathExpression(paths);
                attrPath.setPathReference((PathReference)new SimplePathReference(this.rootNode, propertyPath, this.m.type(extendedAttribute.getElementClass())));
                this.pathExpressions.add(attrPath);
            }
        }
    }

    public void visit(ListIndexExpression expression) {
    }

    public void visit(MapEntryExpression expression) {
    }

    public void visit(MapKeyExpression expression) {
    }

    public void visit(MapValueExpression expression) {
    }
}

