/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import jakarta.persistence.metamodel.Attribute;
import java.util.NavigableMap;
import java.util.TreeMap;

public class JoinTreeNode {
    private final String relationName;
    private final Attribute<?, ?> attribute;
    private JoinNode defaultNode;
    private final boolean collection;
    private final boolean map;
    private final boolean optional;
    private final NavigableMap<String, JoinNode> joinNodes = new TreeMap<String, JoinNode>();

    public JoinTreeNode(String relationName, Attribute<?, ?> attribute) {
        this.relationName = relationName;
        this.attribute = attribute;
        this.collection = attribute.isCollection();
        this.map = JpaMetamodelUtils.isMap(attribute);
        this.optional = JpaMetamodelUtils.isOptional(attribute);
    }

    public String getRelationName() {
        return this.relationName;
    }

    public Attribute<?, ?> getAttribute() {
        return this.attribute;
    }

    public JoinNode getDefaultNode() {
        return this.defaultNode;
    }

    public NavigableMap<String, JoinNode> getJoinNodes() {
        return this.joinNodes;
    }

    public JoinNode getJoinNode(String alias, boolean defaultJoin) {
        if (defaultJoin) {
            return this.defaultNode;
        }
        return (JoinNode)this.joinNodes.get(alias);
    }

    public void addJoinNode(JoinNode node, boolean defaultJoin) {
        if (defaultJoin) {
            if (this.defaultNode != null) {
                throw new IllegalStateException("Tried to add a default node to the tree node although one already exists!");
            }
            this.defaultNode = node;
        }
        this.joinNodes.put(node.getAliasInfo().getAlias(), node);
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isMap() {
        return this.map;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

