/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.OrderByManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.impl.transform.SizeTransformationVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.util.ExpressionUtils;

public class SizeSelectInfoTransformer
implements ExpressionModifierVisitor<SelectInfo> {
    private final OrderByManager orderByManager;
    private final SizeTransformationVisitor sizeTransformationVisitor;

    public SizeSelectInfoTransformer(SizeTransformationVisitor sizeTransformationVisitor, OrderByManager orderByManager) {
        this.sizeTransformationVisitor = sizeTransformationVisitor;
        this.orderByManager = orderByManager;
    }

    @Override
    public void visit(SelectInfo info, ClauseType clauseType) {
        this.sizeTransformationVisitor.setClause(clauseType);
        this.sizeTransformationVisitor.setOrderBySelectClause(this.orderByManager.containsOrderBySelectAlias(info.getAlias()));
        if (ExpressionUtils.isSizeFunction((Expression)info.getExpression())) {
            this.sizeTransformationVisitor.visit(info);
        } else {
            info.getExpression().accept((Expression.ResultVisitor)this.sizeTransformationVisitor);
        }
    }
}

