/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core;

import com.capgemini.mrchecker.test.core.BaseTestWatcher;
import com.capgemini.mrchecker.test.core.IBaseTest;
import com.capgemini.mrchecker.test.core.ITestObserver;
import com.capgemini.mrchecker.test.core.analytics.AnalyticsProvider;
import com.capgemini.mrchecker.test.core.analytics.IAnalytics;
import com.capgemini.mrchecker.test.core.base.encryption.DataEncryptionModule;
import com.capgemini.mrchecker.test.core.base.encryption.IDataEncryptionService;
import com.capgemini.mrchecker.test.core.base.environment.EnvironmentModule;
import com.capgemini.mrchecker.test.core.base.environment.IEnvironmentService;
import com.capgemini.mrchecker.test.core.base.properties.PropertiesCoreTest;
import com.capgemini.mrchecker.test.core.base.properties.PropertiesSettingsModule;
import com.capgemini.mrchecker.test.core.base.runtime.RuntimeParametersCore;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.capgemini.mrchecker.test.core.testRunners.ParallelTestClassRunner;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=ParallelTestClassRunner.class)
public abstract class BaseTest
implements IBaseTest {
    private static IEnvironmentService environmentService;
    private static final IAnalytics analytics;
    private static final PropertiesCoreTest setPropertiesSettings;
    private BaseTestWatcher baseTestWatcher = new BaseTestWatcher(this);
    @Rule
    public TestWatcher testWatcher = this.getBaseTestWatcher();
    @ClassRule
    public static BaseTestWatcher.TestClassRule classRule;

    public BaseTest() {
        BaseTest.getAnalytics().sendClassName();
    }

    public static IEnvironmentService getEnvironmentService() {
        return environmentService;
    }

    public static IAnalytics getAnalytics() {
        return analytics;
    }

    public static void setEnvironmentService(IEnvironmentService environmentService) {
        BaseTest.environmentService = environmentService;
    }

    @BeforeClass
    public static final void setUpClass() throws MalformedURLException {
    }

    @AfterClass
    public static final void tearDownClass() {
        BFLogger.logDebug("BaseTest.tearDownClass()");
        BFLogger.logDebug("BaseTestWatcher.observers: " + BaseTestWatcher.observers.get().toString());
        BFLogger.logDebug("TestClassRule.classObservers: " + BaseTestWatcher.TestClassRule.classObservers.get().toString());
        BaseTestWatcher.TestClassRule.classObservers.get().forEach(ITestObserver::onTestClassFinish);
        BaseTestWatcher.observers.get().forEach(ITestObserver::onTestClassFinish);
        BaseTestWatcher.observers.get().clear();
        BaseTestWatcher.TestClassRule.classObservers.get().clear();
        BFLogger.logDebug("All observers cleared.");
    }

    @After
    public void tearDownTestLast() {
    }

    @Override
    public abstract void setUp();

    @Override
    public abstract void tearDown();

    private static void setEnvironmetInstance(boolean isEncryptionEnabled) {
        IEnvironmentService environmentInstance = (IEnvironmentService)Guice.createInjector((Module[])new Module[]{new EnvironmentModule()}).getInstance(IEnvironmentService.class);
        environmentInstance.setEnvironment(RuntimeParametersCore.ENV.getValue());
        if (isEncryptionEnabled) {
            IDataEncryptionService encryptionService = (IDataEncryptionService)Guice.createInjector((Module[])new Module[]{new DataEncryptionModule()}).getInstance(IDataEncryptionService.class);
            environmentInstance.setDataEncryptionService(encryptionService);
        }
        BaseTest.setEnvironmentService(environmentInstance);
    }

    private static void setRuntimeParametersCore() {
        BFLogger.logDebug(RuntimeParametersCore.ENV.toString());
    }

    private static PropertiesCoreTest setPropertiesSettings() {
        PropertiesCoreTest propertiesCoreTest = (PropertiesCoreTest)Guice.createInjector((Module[])new Module[]{PropertiesSettingsModule.init()}).getInstance(PropertiesCoreTest.class);
        return propertiesCoreTest;
    }

    private static IAnalytics setAnalytics(Boolean isAnalyticsEnabled) {
        BFLogger.logAnalytics("Is analytics enabled:" + isAnalyticsEnabled);
        return isAnalyticsEnabled != false ? AnalyticsProvider.DISABLED : AnalyticsProvider.DISABLED;
    }

    public BaseTestWatcher getBaseTestWatcher() {
        return this.baseTestWatcher;
    }

    static {
        setPropertiesSettings = BaseTest.setPropertiesSettings();
        BaseTest.setRuntimeParametersCore();
        BaseTest.setEnvironmetInstance(setPropertiesSettings.isEncryptionEnabled());
        analytics = BaseTest.setAnalytics(setPropertiesSettings.isAnalyticsEnabled());
        classRule = new BaseTestWatcher.TestClassRule();
    }
}

