/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core;

import com.capgemini.mrchecker.test.core.BaseTest;
import com.capgemini.mrchecker.test.core.ITestObserver;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import io.qameta.allure.Attachment;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.BeforeClass;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class BaseTestWatcher
extends TestWatcher {
    private BaseTest baseTest;
    private long iStart;
    static final ThreadLocal<List<ITestObserver>> observers = new ThreadLocal<List<ITestObserver>>(){

        @Override
        protected List<ITestObserver> initialValue() {
            return new ArrayList<ITestObserver>();
        }
    };

    public BaseTestWatcher(BaseTest baseTest) {
        this.baseTest = baseTest;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    BaseTestWatcher.this.starting(description);
                    base.evaluate();
                    BaseTestWatcher.this.succeeded(description);
                }
                catch (org.junit.internal.AssumptionViolatedException e) {
                    errors.add(e);
                    BaseTestWatcher.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable e) {
                    errors.add(e);
                    BaseTestWatcher.this.failed(e, description);
                }
                finally {
                    BaseTestWatcher.this.finished(description);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    protected void starting(Description description) {
        String testName = description.getDisplayName();
        this.startingTestWatcher(testName);
    }

    public void startingTestWatcher(String testName) {
        BFLogger.RestrictedMethods.startSeparateLog();
        BFLogger.logInfo("\"" + testName + "\". STARTED.");
        this.iStart = System.currentTimeMillis();
        BaseTest.getAnalytics().sendClassName();
        this.baseTest.setUp();
    }

    protected void finished(Description description) {
        String testName = description.getDisplayName();
        this.finishedTestWatcher(testName);
    }

    public void finishedTestWatcher(String testName) {
        this.iStart = System.currentTimeMillis() - this.iStart;
        this.printTimeExecutionLog(testName);
        this.baseTest.tearDown();
        this.makeLogForTest();
        observers.get().forEach(ITestObserver::onTestFinish);
    }

    protected void succeeded(Description description) {
        String testName = description.getDisplayName();
        this.succeededTestWatcher(testName);
    }

    public void succeededTestWatcher(String testName) {
        BFLogger.logInfo("\"" + testName + "\". PASSED.");
        TestClassRule.classObservers.get().forEach(ITestObserver::onTestSuccess);
        observers.get().forEach(ITestObserver::onTestSuccess);
    }

    protected void failed(Throwable e, Description description) {
        String testName = description.getDisplayName();
        this.failedTestWatcher(testName);
    }

    public void failedTestWatcher(String testName) {
        BFLogger.logInfo("\"" + testName + "\".FAILED.");
        TestClassRule.classObservers.get().forEach(ITestObserver::onTestFailure);
        observers.get().forEach(ITestObserver::onTestFailure);
    }

    @Attachment(value="Log file")
    public String makeLogForTest() {
        return BFLogger.RestrictedMethods.dumpSeparateLog();
    }

    public static void addObserver(ITestObserver observer) {
        BFLogger.logDebug("To add observer: " + observer.toString());
        boolean anyMatchTestClassObservers = TestClassRule.classObservers.get().stream().anyMatch(x -> x.getModuleType().equals((Object)observer.getModuleType()));
        boolean anyMatchMethodObservers = observers.get().stream().anyMatch(x -> x.getModuleType().equals((Object)observer.getModuleType()));
        BFLogger.logDebug("BaseTestWatcher.observers: " + observers.get().toString());
        BFLogger.logDebug("TestClassRule.classObservers: " + TestClassRule.classObservers.get().toString());
        if (!(anyMatchMethodObservers | anyMatchTestClassObservers)) {
            if (BaseTestWatcher.isAddedFromBeforeClassMethod()) {
                TestClassRule.classObservers.get().add(observer);
            } else {
                observers.get().add(observer);
            }
            BFLogger.logDebug("Added observer: " + observer.toString());
        }
    }

    public static void removeObserver(ITestObserver observer) {
        BFLogger.logDebug("To remove observer: " + observer.toString());
        if (BaseTestWatcher.isAddedFromBeforeClassMethod()) {
            TestClassRule.classObservers.get().remove(observer);
            BFLogger.logDebug("Removed observer: " + observer.toString());
        } else if (!TestClassRule.classObservers.get().isEmpty()) {
            observers.get().remove(observer);
            BFLogger.logDebug("Removed observer: " + observer.toString());
        }
    }

    private void skippedQuietly(org.junit.internal.AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            if (e instanceof AssumptionViolatedException) {
                this.skipped((AssumptionViolatedException)e, description);
            } else {
                this.skipped(e, description);
            }
        }
        catch (Throwable e1) {
            errors.add(e1);
        }
    }

    private static boolean isAddedFromBeforeClassMethod() {
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            try {
                Method method = Class.forName(elem.getClassName()).getDeclaredMethod(elem.getMethodName(), new Class[0]);
                if (method.getDeclaredAnnotation(BeforeClass.class) == null) continue;
                return true;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return false;
    }

    private void printTimeExecutionLog(String testName) {
        BFLogger.logInfo("Test: \"" + testName + "\". " + this.getFormatedTestDuration());
    }

    private String getFormatedTestDuration() {
        return String.format(" Duration: %1.2f min", Float.valueOf((float)this.iStart / 60000.0f));
    }

    public static class TestClassRule
    extends ExternalResource {
        static final ThreadLocal<List<ITestObserver>> classObservers = new ThreadLocal<List<ITestObserver>>(){

            @Override
            protected List<ITestObserver> initialValue() {
                return new ArrayList<ITestObserver>();
            }
        };

        protected void after() {
            classObservers.get().clear();
        }
    }
}

