/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.base.encryption.providers;

import com.capgemini.mrchecker.test.core.base.encryption.IDataEncryptionService;
import com.capgemini.mrchecker.test.core.exceptions.BFSecureModuleException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class DataEncryptionService
implements IDataEncryptionService {
    private static IDataEncryptionService instance;
    private StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();

    private DataEncryptionService(File path) {
        Preconditions.checkNotNull((Object)path);
        this.setSecret(this.readSecret(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataEncryptionService init(File path) {
        if (instance != null) return instance;
        Class<DataEncryptionService> clazz = DataEncryptionService.class;
        synchronized (DataEncryptionService.class) {
            if (instance != null) return instance;
            instance = new DataEncryptionService(path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static IDataEncryptionService getInstance() {
        return instance;
    }

    public static void delInstance() {
        instance = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSecret(File secretFile) {
        try (Scanner scanner = new Scanner(secretFile);){
            String string = this.readLine(scanner, secretFile).trim();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new BFSecureModuleException("File does not exist: " + secretFile);
        }
    }

    private String readLine(Scanner scanner, File secretFile) {
        if (scanner.hasNext()) {
            return scanner.next();
        }
        throw new BFSecureModuleException("File is empty: " + secretFile);
    }

    @Override
    public String encrypt(String text) {
        try {
            return PropertyValueEncryptionUtils.encrypt((String)text, (StringEncryptor)this.encryptor);
        }
        catch (Throwable t) {
            throw new BFSecureModuleException(t.getMessage(), t);
        }
    }

    @Override
    public String decrypt(String text) {
        if (!this.isEncrypted(text)) {
            throw new BFSecureModuleException("Text is not encrypted: " + text);
        }
        try {
            return PropertyValueEncryptionUtils.decrypt((String)text, (StringEncryptor)this.encryptor);
        }
        catch (Throwable t) {
            throw new BFSecureModuleException(t.getMessage(), t);
        }
    }

    @Override
    public void setSecret(String secret) {
        if (secret == null) {
            throw new BFSecureModuleException("Secret must not be null");
        }
        if (!secret.trim().equals(secret)) {
            throw new BFSecureModuleException("Secret contains whitespaces which are trimable. This can cause problems when using command line tools for encryption, due which is not allowed.");
        }
        if (secret.length() < 8) {
            throw new BFSecureModuleException("Secrets must not be shorter than 8 characters");
        }
        if (this.encryptor.isInitialized()) {
            this.encryptor = new StandardPBEStringEncryptor();
        }
        this.encryptor.setPassword(secret);
    }

    @Override
    public boolean isEncrypted(String text) {
        if (text == null) {
            return false;
        }
        return PropertyValueEncryptionUtils.isEncryptedValue((String)text);
    }
}

