/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.base.environment.providers;

import com.capgemini.mrchecker.test.core.base.encryption.IDataEncryptionService;
import com.capgemini.mrchecker.test.core.base.environment.IEnvironmentService;
import com.capgemini.mrchecker.test.core.exceptions.BFInputDataException;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@Singleton
public class SpreadsheetEnvironmentService
implements IEnvironmentService {
    private static IEnvironmentService instance;
    private List<CSVRecord> records;
    private Map<String, String> services;
    private Optional<IDataEncryptionService> encryptionService = Optional.empty();
    private String path;
    private String environmentName;

    private SpreadsheetEnvironmentService(String path, String environmentName) {
        this.path = path;
        this.fetchEnvData(path);
        this.setEnvironment(environmentName);
        BFLogger.logDebug("Reading environment from: " + path);
    }

    public static IEnvironmentService init() {
        String path = SpreadsheetEnvironmentService.class.getResource("").getPath() + "/environments/environments.csv";
        String environment = "DEV";
        return SpreadsheetEnvironmentService.init(path, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEnvironmentService init(String path, String environment) {
        if (instance != null) return instance;
        Class<SpreadsheetEnvironmentService> clazz = SpreadsheetEnvironmentService.class;
        synchronized (SpreadsheetEnvironmentService.class) {
            if (instance != null) return instance;
            instance = new SpreadsheetEnvironmentService(path, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public static IEnvironmentService getInstance() {
        return instance;
    }

    public static void delInstance() {
        instance = null;
    }

    @Override
    public void setEnvironment(String environmentName) {
        this.environmentName = environmentName;
        this.updateServicesMapBasedOn(environmentName);
    }

    @Override
    public String getEnvironment() {
        return this.environmentName;
    }

    @Override
    public String getValue(String serviceName) {
        String value = this.services.get(serviceName);
        if (value == null) {
            throw new BFInputDataException("service " + serviceName + " retrieve address of not found in available services table");
        }
        return value;
    }

    private void fetchEnvData(String path) throws BFInputDataException {
        File csvData = new File(path);
        try {
            CSVParser parser = CSVParser.parse((File)csvData, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.RFC4180);
            this.records = parser.getRecords();
        }
        catch (IOException e) {
            throw new BFInputDataException("Unable to parse CSV: " + path);
        }
    }

    private void updateServicesMapBasedOn(String environmentName) {
        this.services = new HashMap<String, String>();
        int environmentNumber = this.getEnvironmentNumber(environmentName);
        Iterator<CSVRecord> it = this.records.iterator();
        it.next();
        while (it.hasNext()) {
            CSVRecord record = it.next();
            String key = record.get(0);
            String value = record.get(environmentNumber).trim();
            value = this.optionalDecrypt(value);
            this.services.put(key, value);
        }
    }

    private String optionalDecrypt(String value) {
        if (this.encryptionService.isPresent() && this.encryptionService.get().isEncrypted(value)) {
            return this.encryptionService.get().decrypt(value);
        }
        return value;
    }

    private int getEnvironmentNumber(String environmentName) throws BFInputDataException {
        CSVRecord header = this.records.get(0);
        for (int environmentNumber = 0; environmentNumber < header.size(); ++environmentNumber) {
            String environment = header.get(environmentNumber);
            if (!environment.equals(environmentName)) continue;
            BFLogger.logInfo("Selected Environment: " + environmentName);
            return environmentNumber;
        }
        throw new BFInputDataException("There is no Environment with name '" + environmentName + "' available");
    }

    @Override
    public String dataSource() {
        return this.path;
    }

    @Override
    public void setDataEncryptionService(IDataEncryptionService service) {
        this.encryptionService = Optional.ofNullable(service);
        this.setEnvironment(this.getEnvironment());
    }
}

