/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.base.properties;

import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Properties;

@Singleton
public class PropertiesSettingsModule
extends AbstractModule {
    private static PropertiesSettingsModule instance;
    private String path;

    private PropertiesSettingsModule(String path) {
        this.path = path;
        BFLogger.logDebug("Properties settings file path=" + this.path);
    }

    protected void configure() {
        if (!this.exists(this.path)) {
            this.addError("Could not configure properties file. Path='" + this.path + "' does not exist", new Object[0]);
        }
        try {
            Properties properties = this.loadProperties(this.path);
            Names.bindProperties((Binder)this.binder(), (Properties)properties);
        }
        catch (RuntimeException e) {
            this.addError("Could not configure properties file", new Object[]{e});
        }
    }

    public static PropertiesSettingsModule init() {
        String path = System.getProperty("user.dir") + Paths.get("/src/resources/settings.properties", new String[0]);
        return PropertiesSettingsModule.init(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertiesSettingsModule init(String path) {
        if (instance != null) return instance;
        Class<PropertiesSettingsModule> clazz = PropertiesSettingsModule.class;
        synchronized (PropertiesSettingsModule.class) {
            if (instance != null) return instance;
            instance = new PropertiesSettingsModule(path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static void delInstance() {
        instance = null;
    }

    private boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    private Properties loadProperties(String path) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path);
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

