/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.logger;

import com.capgemini.mrchecker.test.core.logger.BFLoggerInstance;

public class BFLogger {
    private static ThreadLocal<BFLoggerInstance> loggers = new ThreadLocal<BFLoggerInstance>(){

        @Override
        protected BFLoggerInstance initialValue() {
            return new BFLoggerInstance();
        }
    };

    public static BFLoggerInstance getLog() {
        return loggers.get();
    }

    public static void logInfo(String message) {
        BFLogger.getLog().logInfo(message);
    }

    public static void logDebug(String message) {
        BFLogger.getLog().logDebug(message);
    }

    public static void logAnalytics(String message) {
        BFLogger.getLog().logAnalytics(message);
    }

    public static void logFunctionBegin(String functionName) {
        BFLogger.getLog().logFunctionBegin(functionName);
    }

    public static void logFunctionEnd() {
        BFLogger.getLog().logFunctionEnd();
    }

    public static void logError(String message) {
        BFLogger.getLog().logError(message);
    }

    public static void logEnv(String message) {
        BFLogger.getLog().logEnv(message);
    }

    public static void logTime(long startTime, String method) {
        double elapsedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        BFLogger.getLog().logDebug("Waiting for [" + method + "] took [" + elapsedTime + " s]");
    }

    public static void logTime(long startTime, String method, String argument) {
        BFLogger.logTime(startTime, method + ": " + argument);
    }

    public static class RestrictedMethods {
        public static void startSeparateLog() {
            BFLogger.getLog().startSeparateLog();
        }

        public static String dumpSeparateLog() {
            return BFLogger.getLog().dumpSeparateLog();
        }
    }
}

