/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.logger;

import com.capgemini.mrchecker.test.core.logger.EnvironmentLevel;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class BFLoggerInstance {
    private final String FBEGIN = "Function: ";
    private final String FEND = "END";
    private static final String logPattern = "%d{yyyy-MM-dd 'at' HH:mm:ss z} %M - %m%x%n";
    private static final Level loggerLevel;
    private File directory;
    private File logFile;
    private String appenderName;
    private Logger logger;
    private int logLevel = 0;

    protected BFLoggerInstance() {
    }

    private AsyncAppender wrapAsync(Appender appender) {
        AsyncAppender wrapper = new AsyncAppender();
        wrapper.addAppender(appender);
        return wrapper;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.getAppenderName());
            this.logger.removeAllAppenders();
            this.logger.setLevel(loggerLevel);
            this.logger.addAppender((Appender)this.createEnvFileAppender());
            this.logger.addAppender((Appender)this.createFileAppender());
            this.logger.addAppender((Appender)this.wrapAsync((Appender)this.createConsoleAppender()));
        }
        return this.logger;
    }

    private FileAppender createEnvFileAppender() {
        FileAppender appender;
        PatternLayout patternLayout = new PatternLayout(logPattern);
        try {
            String envLogName = this.getLogFile().getPath().replace(".log", "_env.log");
            appender = new FileAppender((Layout)patternLayout, envLogName, true);
            appender.setName("EnvRollingFile");
            appender.setThreshold((Priority)EnvironmentLevel.ENVIRONMENT);
            appender.activateOptions();
        }
        catch (Exception e) {
            System.out.println("Unable to create appender: " + e);
            return null;
        }
        return appender;
    }

    private FileAppender createFileAppender() {
        FileAppender appender;
        PatternLayout patternLayout = new PatternLayout(logPattern);
        try {
            appender = new FileAppender((Layout)patternLayout, this.getLogFile().getPath(), true);
            appender.setName(this.getAppenderName());
            appender.setThreshold((Priority)Level.DEBUG);
            appender.activateOptions();
        }
        catch (Exception e) {
            System.out.println("Unable to create appender: " + e);
            return null;
        }
        return appender;
    }

    private ConsoleAppender createConsoleAppender() {
        ConsoleAppender appender;
        PatternLayout patternLayout = new PatternLayout(logPattern);
        try {
            appender = new ConsoleAppender((Layout)patternLayout);
            appender.setTarget("System.out");
            appender.setName("Console");
            appender.setThreshold((Priority)Level.DEBUG);
            appender.activateOptions();
        }
        catch (Exception e) {
            System.out.println("Unable to create appender: " + e);
            return null;
        }
        return appender;
    }

    private File getLogFile() {
        if (this.logFile == null) {
            String path = this.getDirectory().getPath() + "\\" + this.getAppenderName() + ".log";
            this.logFile = new File(path);
            this.logFile.deleteOnExit();
        }
        return this.logFile;
    }

    private File getDirectory() {
        if (this.directory == null) {
            this.directory = new File("./logs");
            if (!this.directory.exists()) {
                this.directory.mkdir();
            }
        }
        return this.directory;
    }

    private String getAppenderName() {
        if (this.appenderName == null) {
            this.appenderName = Thread.currentThread().getName();
        }
        return this.appenderName;
    }

    public void logInfo(String message) {
        this.getLogger().info((Object)this.formatMessage(message));
    }

    public void logEnv(String message) {
        this.getLogger().log((Priority)EnvironmentLevel.ENVIRONMENT, (Object)message);
        if (message.equals("END")) {
            --this.logLevel;
        }
    }

    public void logDebug(String message) {
        char[] indent = new char[this.logLevel];
        Arrays.fill(indent, ' ');
        this.getLogger().debug((Object)this.formatMessage(new String(indent) + message));
    }

    public void logAnalytics(String message) {
        char[] indent = new char[this.logLevel];
        Arrays.fill(indent, ' ');
        this.getLogger().debug((Object)this.formatMessage(new String(indent) + message));
    }

    public void logFunctionBegin(String functionName) {
        this.logDebug("Function: " + functionName);
        ++this.logLevel;
    }

    public void logFunctionEnd() {
        --this.logLevel;
        this.logDebug("END");
    }

    public void logError(String message) {
        this.getLogger().error((Object)this.formatMessage(message));
        if (message.equals("END")) {
            --this.logLevel;
        }
    }

    private String formatMessage(String message) {
        return "[" + this.getAppenderName() + "] " + message;
    }

    protected void startSeparateLog() {
        try {
            PrintWriter pw = new PrintWriter(this.getLogFile());
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected String dumpSeparateLog() {
        try {
            String logTxt = Files.toString((File)this.getLogFile(), (Charset)Charsets.UTF_8);
            return logTxt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        Logger.getRootLogger().removeAppender("console");
        loggerLevel = Level.DEBUG;
    }
}

