/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.testRunners.core;

import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class CustomRunAfters
extends Statement {
    private final Statement next;
    private final Object target;
    private final List<FrameworkMethod> afters;

    public CustomRunAfters(Statement next, List<FrameworkMethod> afters, Object target) {
        this.next = next;
        this.afters = afters;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.next.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            for (FrameworkMethod each : this.afters) {
                try {
                    each.invokeExplosively(this.target, new Object[0]);
                }
                catch (Throwable e) {
                    BFLogger.logError("There was an exception in @AfterClass " + each.getName() + ": " + e.toString());
                }
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

