/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.test.core.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class NumberUtils {
    public static final String DOLLAR_REGEX = "\\$(?:0|[1-9]\\d{0,2}(?:,?\\d{3})*)(\\.\\d{2})";
    public static final BigDecimal delta = new BigDecimal("0.02");

    private NumberUtils() {
    }

    public static BigDecimal getValueFromStringAmount(String text) {
        BigDecimal value = BigDecimal.ZERO;
        if (text.matches("^[-+]?\\+?\\$\\d+.*")) {
            value = NumberUtils.convertTextValueToDecimal(text);
        }
        return value;
    }

    public static BigDecimal convertTextValueToDecimal(String textValue) {
        if (textValue == null || textValue.isEmpty()) {
            return BigDecimal.ZERO;
        }
        String textToConvert = textValue.replaceAll("\\$|\\,|\\%|\\(Margin\\)|\\#|\\(|\\)|\\\u2021|\\\u00a7|\\/Share|\\+*$|\\n|\\r|(--)|\\Short", "");
        if (textToConvert.isEmpty()) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(textToConvert).setScale(2, 3);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Cannot convert [" + textToConvert + "].");
        }
    }

    public static BigDecimal[] convertTextValueToDecimal(String[] textValues) {
        return NumberUtils.convertTextValueToDecimal(Arrays.asList(textValues));
    }

    public static BigDecimal[] convertTextValueToDecimal(Iterable<String> textValues) {
        ArrayList<BigDecimal> currencies = new ArrayList<BigDecimal>();
        for (String textValue : textValues) {
            BigDecimal value = NumberUtils.convertTextValueToDecimal(textValue);
            currencies.add(value);
        }
        return currencies.toArray(new BigDecimal[currencies.size()]);
    }

    public static boolean isNumeric(String textValue) {
        return textValue.matches("-?(\\$)?(\\d+)+(,\\d+)*(\\.\\d+)?");
    }

    public static boolean isTwoDecimalPlaces(String textValue) {
        return textValue.matches(".*\\.\\d{2}$?");
    }

    public static boolean isDifferenceMajor(BigDecimal oneValue, BigDecimal secondValue) {
        BigDecimal acceptedDifference = BigDecimal.ONE;
        BigDecimal absDifference = oneValue.subtract(secondValue).abs();
        return absDifference.compareTo(acceptedDifference) > 0;
    }

    public static int getRandomInteger(int seed) {
        Random rnd = new Random();
        return rnd.nextInt(seed);
    }

    public static boolean isPercentRoundedTo2decimalPlaces(String percent) {
        String pr = percent.replaceAll("%", "").replaceAll(",", "").trim();
        BigDecimal precentAsBD = new BigDecimal(pr);
        BigDecimal decimalPart = precentAsBD.subtract(precentAsBD.setScale(0, RoundingMode.FLOOR)).movePointRight(precentAsBD.scale());
        return decimalPart.intValue() < 100;
    }

    public static String convertNumberToXDecimalPoints(String number, int precision) {
        try {
            return new BigDecimal(number == null || number.isEmpty() ? "0" : number).setScale(precision, 4).toString();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Cannot convert [" + number + "].");
        }
    }

    public static List<String> convertNumberToXDecimalPoints(List<String> numbersList, int precision) {
        for (int i = 0; i < numbersList.size(); ++i) {
            numbersList.set(i, NumberUtils.convertNumberToXDecimalPoints(numbersList.get(i), precision));
        }
        return numbersList;
    }

    public static boolean isBigDecimalDifferent(BigDecimal f1, BigDecimal f2) {
        return NumberUtils.isBigDecimalDifferent(f1, f2, delta);
    }

    public static boolean isBigDecimalDifferent(BigDecimal f1, BigDecimal f2, BigDecimal delta) {
        if (f1.compareTo(f2) == 0) {
            return false;
        }
        return f1.subtract(f2).abs().compareTo(delta) > 0;
    }
}

