/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.mapping;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayResponse;
import com.alipay.api.internal.mapping.AlipayFieldMethod;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.internal.mapping.Reader;
import com.alipay.api.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> baseFields = new HashSet<String>();
    private static final Set<String> excludeFields = new HashSet<String>();
    private static final Set<String> overideFields = new HashSet<String>();

    static {
        baseFields.add("code");
        baseFields.add("msg");
        baseFields.add("subCode");
        baseFields.add("subMsg");
        baseFields.add("body");
        baseFields.add("params");
        baseFields.add("success");
        excludeFields.add("errorCode");
        overideFields.add("code");
        overideFields.add("msg");
    }

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws AlipayApiException {
        T rsp = null;
        try {
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            boolean isResponseClazz = AlipayResponse.class.isAssignableFrom(clazz);
            PropertyDescriptor[] propertyDescriptorArray = pds;
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                block25: {
                    ArrayList<AlipayFieldMethod> alipayFieldMethods;
                    String listName;
                    String itemName;
                    block29: {
                        AlipayFieldMethod alipayFieldMethod;
                        Field field;
                        Method writeMethod;
                        block26: {
                            block28: {
                                block27: {
                                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                                    writeMethod = pd.getWriteMethod();
                                    if (writeMethod == null) break block25;
                                    itemName = pd.getName();
                                    listName = null;
                                    if (isResponseClazz && excludeFields.contains(itemName)) break block25;
                                    alipayFieldMethods = new ArrayList<AlipayFieldMethod>();
                                    if (!baseFields.contains(itemName) || !isResponseClazz) break block26;
                                    field = AlipayResponse.class.getDeclaredField(itemName);
                                    alipayFieldMethod = new AlipayFieldMethod();
                                    alipayFieldMethod.setField(field);
                                    if (!writeMethod.getDeclaringClass().getName().contains("AlipayResponse")) break block27;
                                    alipayFieldMethod.setMethod(writeMethod);
                                    break block28;
                                }
                                if ((writeMethod = Converters.tryGetSetMethod(AlipayResponse.class, field, writeMethod.getName())) == null) break block25;
                                alipayFieldMethod.setMethod(writeMethod);
                            }
                            alipayFieldMethods.add(alipayFieldMethod);
                            if (!overideFields.contains(itemName) || (field = Converters.tryGetFieldWithoutExp(clazz, itemName)) == null) break block29;
                            if ((writeMethod = Converters.tryGetSetMethod(clazz, field, writeMethod.getName())) == null) break block25;
                            alipayFieldMethod = new AlipayFieldMethod();
                            alipayFieldMethod.setField(field);
                            alipayFieldMethod.setMethod(writeMethod);
                            alipayFieldMethods.add(alipayFieldMethod);
                            break block29;
                        }
                        field = clazz.getDeclaredField(itemName);
                        alipayFieldMethod = new AlipayFieldMethod();
                        alipayFieldMethod.setField(field);
                        alipayFieldMethod.setMethod(writeMethod);
                        alipayFieldMethods.add(alipayFieldMethod);
                    }
                    for (AlipayFieldMethod alipayFieldMethod : alipayFieldMethods) {
                        Object value;
                        ApiListField jsonListField;
                        Field field = alipayFieldMethod.getField();
                        Method method = alipayFieldMethod.getMethod();
                        ApiField jsonField = field.getAnnotation(ApiField.class);
                        if (jsonField != null) {
                            itemName = jsonField.value();
                        }
                        if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                            listName = jsonListField.value();
                        }
                        if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                        Class<?> typeClass = field.getType();
                        if (String.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof String) {
                                method.invoke(rsp, value.toString());
                                continue;
                            }
                            if (isCheckJsonType && value != null) {
                                throw new AlipayApiException(String.valueOf(itemName) + " is not a String");
                            }
                            if (value != null) {
                                method.invoke(rsp, value.toString());
                                continue;
                            }
                            method.invoke(rsp, "");
                            continue;
                        }
                        if (Long.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof Long) {
                                method.invoke(rsp, (Long)value);
                                continue;
                            }
                            if (isCheckJsonType && value != null) {
                                throw new AlipayApiException(String.valueOf(itemName) + " is not a Number(Long)");
                            }
                            if (!StringUtils.isNumeric(value)) continue;
                            method.invoke(rsp, Long.valueOf(value.toString()));
                            continue;
                        }
                        if (Integer.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof Integer) {
                                method.invoke(rsp, (Integer)value);
                                continue;
                            }
                            if (isCheckJsonType && value != null) {
                                throw new AlipayApiException(String.valueOf(itemName) + " is not a Number(Integer)");
                            }
                            if (!StringUtils.isNumeric(value)) continue;
                            method.invoke(rsp, Integer.valueOf(value.toString()));
                            continue;
                        }
                        if (Boolean.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof Boolean) {
                                method.invoke(rsp, (Boolean)value);
                                continue;
                            }
                            if (isCheckJsonType && value != null) {
                                throw new AlipayApiException(String.valueOf(itemName) + " is not a Boolean");
                            }
                            if (value == null) continue;
                            method.invoke(rsp, Boolean.valueOf(value.toString()));
                            continue;
                        }
                        if (Double.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof Double) {
                                method.invoke(rsp, (Double)value);
                                continue;
                            }
                            if (!isCheckJsonType || value == null) continue;
                            throw new AlipayApiException(String.valueOf(itemName) + " is not a Double");
                        }
                        if (Number.class.isAssignableFrom(typeClass)) {
                            value = reader.getPrimitiveObject(itemName);
                            if (value instanceof Number) {
                                method.invoke(rsp, (Number)value);
                                continue;
                            }
                            if (!isCheckJsonType || value == null) continue;
                            throw new AlipayApiException(String.valueOf(itemName) + " is not a Number");
                        }
                        if (Date.class.isAssignableFrom(typeClass)) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                            Object value2 = reader.getPrimitiveObject(itemName);
                            if (!(value2 instanceof String)) continue;
                            method.invoke(rsp, format.parse(value2.toString()));
                            continue;
                        }
                        if (List.class.isAssignableFrom(typeClass)) {
                            Class subType;
                            List<?> listObjs;
                            ParameterizedType paramType;
                            Type[] genericTypes;
                            Type fieldType = field.getGenericType();
                            if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                            method.invoke(rsp, listObjs);
                            continue;
                        }
                        Object obj = reader.getObject(itemName, typeClass);
                        if (obj == null) continue;
                        method.invoke(rsp, obj);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new AlipayApiException(e);
        }
        return rsp;
    }

    private static Field tryGetFieldWithoutExp(Class<?> clazz, String itemName) {
        try {
            return clazz.getDeclaredField(itemName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Method tryGetSetMethod(Class<T> clazz, Field field, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }
}

