/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.parser.xml;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.Decryptor;
import com.alipay.api.ResponseParseItem;
import com.alipay.api.SignItem;
import com.alipay.api.internal.mapping.Converter;
import com.alipay.api.internal.mapping.Converters;
import com.alipay.api.internal.mapping.Reader;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.XmlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class XmlConverter
implements Converter {
    @Override
    public <T extends AlipayResponse> T toResponse(String rsp, Class<T> clazz) throws AlipayApiException {
        Element root = XmlUtils.getRootElementFromString(rsp);
        return (T)((AlipayResponse)this.getModelFromXML(root, clazz));
    }

    private <T> T getModelFromXML(final Element element, Class<T> clazz) throws AlipayApiException {
        if (element == null) {
            return null;
        }
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                return childE != null;
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return XmlUtils.getElementValue(element, (String)name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws AlipayApiException {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                if (childE != null) {
                    return XmlConverter.this.getModelFromXML(childE, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws AlipayApiException {
                ArrayList<String> list = null;
                Element listE = XmlUtils.getChildElement(element, (String)listName);
                if (listE != null) {
                    list = new ArrayList<String>();
                    List<Element> itemEs = XmlUtils.getChildElements(listE, (String)itemName);
                    for (Element itemE : itemEs) {
                        Object obj = null;
                        String value = XmlUtils.getElementValue(itemE);
                        if (String.class.isAssignableFrom(subType)) {
                            obj = value;
                        } else if (Long.class.isAssignableFrom(subType)) {
                            obj = Long.valueOf(value);
                        } else if (Integer.class.isAssignableFrom(subType)) {
                            obj = Integer.valueOf(value);
                        } else if (Boolean.class.isAssignableFrom(subType)) {
                            obj = Boolean.valueOf(value);
                        } else if (Date.class.isAssignableFrom(subType)) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                obj = format.parse(value);
                            }
                            catch (ParseException e) {
                                throw new AlipayApiException(e);
                            }
                        } else {
                            obj = XmlConverter.this.getModelFromXML(itemE, subType);
                        }
                        if (obj == null) continue;
                        list.add((String)obj);
                    }
                }
                return list;
            }
        });
    }

    @Override
    public SignItem getSignItem(AlipayRequest<?> request, String responseBody) throws AlipayApiException {
        if (StringUtils.isEmpty(responseBody)) {
            return null;
        }
        SignItem signItem = new SignItem();
        String sign = this.getSign(responseBody);
        signItem.setSign(sign);
        String signSourceData = this.getSignSourceData(request, responseBody);
        signItem.setSignSourceDate(signSourceData);
        return signItem;
    }

    private String getSignSourceData(AlipayRequest<?> request, String body) {
        String rootNode = String.valueOf(request.getApiMethodName().replace('.', '_')) + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private String getSign(String body) {
        String signNodeName = "<sign>";
        String signEndNodeName = "</sign>";
        int indexOfSignNode = body.indexOf(signNodeName);
        int indexOfSignEndNode = body.indexOf(signEndNodeName);
        if (indexOfSignNode < 0 || indexOfSignEndNode < 0) {
            return null;
        }
        return body.substring(indexOfSignNode + signNodeName.length(), indexOfSignEndNode);
    }

    private String parseSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 1;
        int indexOfSign = body.indexOf("<sign");
        if (indexOfSign < 0) {
            return null;
        }
        int signDataEndIndex = indexOfSign;
        return body.substring(signDataStartIndex, signDataEndIndex);
    }

    @Override
    public String decryptSourceData(AlipayRequest<?> request, String body, String format, Decryptor decryptor, String encryptType, String charset) throws AlipayApiException {
        ResponseParseItem respSignSourceData = this.getXMLSignSourceData(request, body);
        String bodyIndexContent = body.substring(0, respSignSourceData.getStartIndex());
        String bodyEndContent = body.substring(respSignSourceData.getEndIndex());
        return String.valueOf(bodyIndexContent) + decryptor.decrypt(respSignSourceData.getEncryptContent(), encryptType, charset) + bodyEndContent;
    }

    private ResponseParseItem getXMLSignSourceData(AlipayRequest<?> request, String body) {
        String rootNode = String.valueOf(request.getApiMethodName().replace('.', '_')) + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseXMLSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseXMLSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private ResponseParseItem parseXMLSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 1;
        String xmlStartNode = "<response_encrypted>";
        String xmlEndNode = "</response_encrypted>";
        int indexOfSign = body.indexOf(xmlEndNode);
        if (indexOfSign < 0) {
            return new ResponseParseItem(0, 0, "");
        }
        int signDataEndIndex = indexOfSign + xmlEndNode.length();
        String encryptBizContent = body.substring(signDataStartIndex, signDataEndIndex);
        String bizContent = encryptBizContent.substring(xmlStartNode.length(), encryptBizContent.length() - xmlEndNode.length());
        return new ResponseParseItem(signDataStartIndex, signDataEndIndex, bizContent);
    }
}

