/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);

    public static String toXml(SortedMap<String, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if ("attach".equalsIgnoreCase(key) || "body".equalsIgnoreCase(key) || "sign".equalsIgnoreCase(key)) {
                sb.append("<" + key + ">" + "<![CDATA[" + value + "]]></" + key + ">");
                continue;
            }
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static SortedMap<String, String> doXMLParse(String xml) {
        TreeMap<String, String> map;
        block5: {
            map = new TreeMap<String, String>();
            if (xml == null) {
                return map;
            }
            xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
            if (xml != null && !"".equals(xml)) break block5;
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((InputStream)in);
            Element root = doc.getRootElement();
            List list = root.getChildren();
            for (Element e : list) {
                String key = e.getName();
                String value = "";
                List children = e.getChildren();
                value = children.isEmpty() ? e.getTextNormalize() : XmlUtils.getChildrenText(children);
                map.put(key, value);
            }
            ((InputStream)in).close();
        }
        catch (IOException | JDOMException ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
        return map;
    }

    public static String getChildrenText(List<Element> children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(XmlUtils.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public static String setXML(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }
}

