package com.crawler.utils;

import com.crawler.config.ConfigProperties;

/**
 * html工具
 * @author rubekid
 *
 * 2017年11月2日 下午11:40:13
 */
public class HtmlUtils {
	
	private static final String TITLE = ConfigProperties.getProperty("app.name", "厦门爬虫科技网络公司");

	/**
	 * 格式化
	 * @param value
	 * @return
	 */
	public static String format(String value){
		value = simpleFormat(value);
		String content = "<html>" +
		"<head>" +
		    "<meta charset=\"utf-8\" />" +
		    "<meta name=\"viewport\" content=\"width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no\"/>" +
		    "<title>"+ TITLE +"</title>" +
		"</head>" +
		"<body>" +
			value + 
		"</body>" +
		"</html>";
		return content;
	}
	
	/**
	 * 简易格式化
	 * @param value
	 * @return
	 */
	public static String simpleFormat(String value){
		//去html包裹
		if(value.indexOf("<body>") > -1){			
			value = value.replaceAll("[\\s\\S]*<body[^>]*>([\\s\\S]+)</body>[\\s\\S]*", "$1");
		}
		//图片处理
		value = value.replaceAll("<img[^>]+src=\"(.*?)(\\?.*?)*\"[^>]*?>", "<img style=\"width:100%;\" src=\"$1?imageView2/2/w/0/h/0/q/80\" />");
		
		return value;
	}
}
