package com.crawler.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.config.PropertiesLoader;
import com.crawler.exception.SimpleRuntimeException;

public class SmsClient {
	
	private static Logger logger = LoggerFactory.getLogger(SmsClient.class);
	
	/**
	 * 属性文件加载对象
	 */
	private static PropertiesLoader loader = new PropertiesLoader("sms.properties");
	
	private static final String SIGN = loader.getProperty("sms.sign", "");
	private static final String SMS_SERVER_URL = loader.getProperty("sms.url");	   //服务器URL 地址
	private static final String CUST_CODE = loader.getProperty("sms.cust_code");									 //账号
	private static final String PASSWORD = loader.getProperty("sms.password");		 								//密码
	private static final String SP_CODE = loader.getProperty("sms.sp_code");                  //接入码（扩展码）
	
	/**
	 * 短信发送
	 * @param phone
	 * @param content
	 */
	public static String send(String phone, String content){
		try {
			String result = SmsClient.sendSms(phone, content);
			System.out.println( DateUtils.getLongNow() + " => 短信发送结果：" + result);
			if(!result.toUpperCase().startsWith("SUCCESS")) {
				throw new SimpleRuntimeException("短信发送失败");
				
			}
			return result;
		} catch (IOException ex) {
			logger.error(ex.getMessage(), ex);
			throw new SimpleRuntimeException("短信发送失败");
		}
	}

	public static String sendSms(String mobiles, String content) throws IOException {
		return sendSms(mobiles, content, SP_CODE, 0);
	}

	public static String sendSms(String mobiles, String content, long task_id) throws IOException {
		return sendSms(mobiles, content, SP_CODE, task_id);
	}

	public static String sendSms(String mobiles, String content, String sp_code) throws IOException {
		return sendSms(mobiles, content, sp_code, 0);
	}

	public static String sendSms(String mobiles, String content, String sp_code, long task_id) throws IOException {
		if(SIGN != null && !"".equals(SIGN)) {			
			content = "【" + SIGN + "】" + content;
		}
		String urlencContent = URLEncoder.encode(content,"utf-8");
        String sign=StringUtils.md5(urlencContent + PASSWORD);
		String postData = "content=" + urlencContent + "&destMobiles="
				+ mobiles + "&sign=" + sign + "&cust_code=" + CUST_CODE
				+ "&sp_code=" + sp_code + "&task_id=" + task_id;
		logger.info(postData);
		URL myurl = new URL(SMS_SERVER_URL);
		URLConnection urlc = myurl.openConnection();
		urlc.setReadTimeout(1000 * 30);
		urlc.setDoOutput(true);
		urlc.setDoInput(true);
		urlc.setAllowUserInteraction(false);

		DataOutputStream server = new DataOutputStream(urlc.getOutputStream());

		server.write(postData.getBytes("utf-8"));
		server.close();

		BufferedReader in = new BufferedReader(new InputStreamReader(
				urlc.getInputStream(), "utf-8"));
		String result = "", s = "";
		while ((s = in.readLine()) != null)
			result = result + s + "\r\n";
		in.close();
		return result;
	}
}