package com.crawler.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.crawler.beans.CategoryNode;
import com.crawler.beans.CategoryTreeNode;
import com.crawler.beans.Node;
import com.crawler.beans.SimpleNode;
import com.crawler.beans.SimpleTreeNode;
import com.crawler.beans.TreeNode;

/**
 * 树工具类
 * @author Rubekid
 *
 * 2017年5月23日 下午4:28:14
 */
public class TreeNodeUtils {

	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<TreeNode> generateTree(List<Node> nodes, String rootId){
		Map<String, List<TreeNode>> map = new HashMap<String, List<TreeNode>>();
		for(Node node : nodes){
			String parentId = node.getParentId();
			List<TreeNode> treeNodes = new ArrayList<TreeNode>();
			if(map.containsKey(parentId)){
				treeNodes = map.get(parentId);
			}
			TreeNode treeNode = new TreeNode();
			treeNode.setId(node.getId());
			treeNode.setName(node.getName());
			treeNode.setImage(node.getImage());
			treeNodes.add(treeNode);
			map.put(parentId, treeNodes);
		}
		
		return buildNode(map, rootId);
		
	}
	
	/**
	 * 组装节点
	 * @param map
	 * @param parentId
	 * @return
	 */
	private static List<TreeNode> buildNode(Map<String, List<TreeNode>> map, String parentId){
		List<TreeNode> nodes = map.get(parentId);
		if(nodes!=null){
			for(TreeNode treeNode : nodes){
				treeNode.setChildren(buildNode(map, treeNode.getId()));
			}
		}
		return nodes;
		
	}
	
	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<SimpleTreeNode> generateTree(List<SimpleNode> nodes, Number rootId){
		Map<Number, List<SimpleTreeNode>> map = new HashMap<Number, List<SimpleTreeNode>>();
		for(SimpleNode node : nodes){
			Number parentId = node.getParentId();
			List<SimpleTreeNode> treeNodes = new ArrayList<SimpleTreeNode>();
			if(map.containsKey(parentId)){
				treeNodes = map.get(parentId);
			}
			SimpleTreeNode treeNode = new SimpleTreeNode();
			treeNode.setId(node.getId());
			treeNode.setName(node.getName());
			treeNodes.add(treeNode);
			map.put(parentId, treeNodes);
		}
		
		return buildSimpleNode(map, rootId);
		
	}
	
	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<SimpleTreeNode> generateTree(List<SimpleNode> nodes){
		return generateTree(nodes, 0);
	}
	
	/**
	 * 组装节点
	 * @param map
	 * @param parentId
	 * @return
	 */
	private static List<SimpleTreeNode> buildSimpleNode(Map<Number, List<SimpleTreeNode>> map, Number parentId){
		List<SimpleTreeNode> nodes = map.get(parentId);
		if(nodes!=null){
			for(SimpleTreeNode treeNode : nodes){
				treeNode.setChildren(buildSimpleNode(map, treeNode.getId()));
			}
		}
		return nodes;
		
	}
	
	

	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<CategoryTreeNode> genCategoryTree(List<CategoryNode> nodes, Number rootId){
		Map<Number, List<CategoryTreeNode>> map = new HashMap<Number, List<CategoryTreeNode>>();
		for(CategoryNode node : nodes){
			Number parentId = node.getParentId();
			List<CategoryTreeNode> treeNodes = new ArrayList<CategoryTreeNode>();
			if(map.containsKey(parentId)){
				treeNodes = map.get(parentId);
			}
			CategoryTreeNode treeNode = new CategoryTreeNode();
			treeNode.setId(node.getId());
			treeNode.setName(node.getName());
			treeNode.setIcon(node.getIcon());
			treeNodes.add(treeNode);
			map.put(parentId, treeNodes);
		}
		
		return buildCategoryNode(map, rootId);
		
	}
	
	/**
	 * 生成树
	 * @param nodes
	 * @return
	 */
	public static List<CategoryTreeNode> genCategoryTree(List<CategoryNode> nodes){
		return genCategoryTree(nodes, 0);
	}
	

	/**
	 * 组装节点
	 * @param map
	 * @param parentId
	 * @return
	 */
	private static List<CategoryTreeNode> buildCategoryNode(Map<Number, List<CategoryTreeNode>> map, Number parentId){
		List<CategoryTreeNode> nodes = map.get(parentId);
		if(nodes!=null){
			for(CategoryTreeNode treeNode : nodes){
				treeNode.setChildren(buildCategoryNode(map, treeNode.getId()));
			}
		}
		return nodes;
		
	}
	
	
}
