/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.http;

import com.crawler.config.ConfigProperties;
import com.crawler.config.JsonMapper;
import com.crawler.exception.SimpleRuntimeException;
import com.crawler.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class SimpleHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static final Integer TIMEOUT = ConfigProperties.getPropertyForInteger("httpclient.timeout", "10000");
    private static CloseableHttpClient httpClient;
    private static CookieStore cookieStore;

    public static String getCookie(String name) {
        List cookies = cookieStore.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void setCookie(String name, String value) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookieStore.getCookies().add(cookie);
    }

    public static String get(String url) {
        return SimpleHttpClient.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) {
        CloseableHttpResponse httpResponse = null;
        HttpGet method = null;
        try {
            method = new HttpGet(url);
            if (headers == null || !headers.containsKey("User-Agent")) {
                method.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36 MicroMessenger/6.5.2.501 NetType/WIFI WindowsWechat QBCore/3.43.691.400 QQBrowser/9.0.2524.400");
            }
            if (headers != null) {
                SimpleHttpClient.addHeaders((HttpRequestBase)method, headers);
            }
            httpResponse = httpClient.execute((HttpUriRequest)method);
            String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            return content;
        }
        catch (IOException | ParseException ex) {
            if (method != null) {
                method.releaseConnection();
            }
            if (ex instanceof SocketTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return "";
        }
    }

    public static String post(String url, Map<String, ?> params, Map<String, String> headers) {
        try {
            CloseableHttpResponse httpResponse;
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(SimpleHttpClient.getParam(params), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36");
            if (headers != null) {
                SimpleHttpClient.addHeaders((HttpRequestBase)httpPost, headers);
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 302) {
                String locationUrl = httpResponse.getLastHeader("Location").getValue();
                httpResponse.getEntity().getContent().close();
                return SimpleHttpClient.get(locationUrl);
            }
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return "";
        }
    }

    public static String postForAlipay(String url, Map<String, ?> params, Map<String, String> headers) {
        try {
            CloseableHttpResponse httpResponse;
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(SimpleHttpClient.getParam(params), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            httpPost.setHeader("User-Agent", "mozilla/5.0 (linux; u; android 6.0.1; zh-cn; mi 5 build/mxb48t) applewebkit/537.36 (khtml, like gecko) version/4.0 chrome/40.0.2214.89 ucbrowser/11.6.4.950 uws/2.11.0.39 mobile safari/537.36 ucbs/2.11.0.39 nebula nebulasdk/1.7.0 alipaydefined(nt:wifi,ws:360|0|3.0) aliapp(ap/10.1.10.1226101) alipayclient/10.1.10.1226101 language/zh-hans usestatusbar/true");
            if (headers != null) {
                SimpleHttpClient.addHeaders((HttpRequestBase)httpPost, headers);
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 302) {
                String locationUrl = httpResponse.getLastHeader("Location").getValue();
                return locationUrl;
            }
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return "";
        }
    }

    public static String postForAlipay(String url) {
        return SimpleHttpClient.postForAlipay(url, null, null);
    }

    public static String postForm(String url, Map<String, ?> params) {
        try {
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(SimpleHttpClient.getParam(params), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException) {
                throw new SimpleRuntimeException("\u8bf7\u6c42\u8d85\u65f6");
            }
            LOGGER.error(ex.getMessage(), ex);
            return "";
        }
    }

    public static String post(String url, JSONObject body) {
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body.toString(), "utf-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException || ex instanceof ConnectTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return "";
        }
    }

    public static HttpResponse postForResponse(String url, JSONObject body) {
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body.toString(), "utf-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            return httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return null;
        }
    }

    public static String post(String url) {
        HashMap params = new HashMap();
        return SimpleHttpClient.post(url, params, null);
    }

    public static String postMultipartForm(String url, Map<String, ?> params, Map<String, String> headers) {
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                Object obj = entry.getValue();
                String key = entry.getKey();
                if (obj instanceof File) {
                    builder.addBinaryBody(key, (File)obj);
                    continue;
                }
                if (obj instanceof FileBody) {
                    builder.addPart(key, (ContentBody)((FileBody)obj));
                    continue;
                }
                builder.addTextBody(key, String.valueOf(obj), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            }
            HttpEntity postEntity = builder.build();
            httpPost.setEntity(postEntity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            if (ex instanceof SocketTimeoutException || ex instanceof ConnectTimeoutException) {
                LOGGER.error("\u8bf7\u6c42\u8d85\u65f6");
            } else {
                LOGGER.error(ex.getMessage(), ex);
            }
            return "";
        }
    }

    public static <T> T getForObject(String url, Class<T> clazz) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.get(url), clazz);
        }
        catch (SimpleRuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> T getForObject(String url, Class<T> clazz, Map<String, String> headers) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.get(url, headers), clazz);
        }
        catch (SimpleRuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> T postForObject(String url, Class<T> clazz) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.post(url), clazz);
        }
        catch (SimpleRuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> T postForObject(String url, JSONObject body, Class<T> clazz) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.post(url, body), clazz);
        }
        catch (SimpleRuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static List<NameValuePair> getParam(Map<String, ?> parameterMap) {
        if (parameterMap == null) {
            parameterMap = new HashMap();
        }
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>();
        for (Map.Entry<String, ?> entry : parameterMap.entrySet()) {
            param.add((NameValuePair)new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return param;
    }

    private static void addHeaders(HttpRequestBase httpRequest, Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private static <T> T toBean(String response, Class<T> clazz) {
        LOGGER.info("\u54cd\u5e94\u6587\u672c\u5185\u5bb9\uff1a{}", (Object)response);
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(JsonMapper.getMapper());
        if (List.class.isAssignableFrom(clazz)) {
            return (T)messageConverter.getObjectMapper().convertValue((Object)JSONArray.fromObject((Object)StringUtils.UrlDecode(response)), clazz);
        }
        return (T)messageConverter.getObjectMapper().convertValue((Object)JSONObject.fromObject((Object)StringUtils.UrlDecode(response)), clazz);
    }

    public CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    static {
        cookieStore = new BasicCookieStore();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(TIMEOUT.intValue()).setConnectTimeout(TIMEOUT.intValue()).build();
        httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setDefaultCookieStore(cookieStore).build();
    }
}

