/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Coords;
import com.crawler.beans.Location;
import com.crawler.config.ConfigProperties;
import com.crawler.http.SimpleHttpClient;
import com.crawler.utils.IpAddressUtils;
import com.crawler.utils.StringUtils;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiduMapUtils.class);
    private static final String KEY = ConfigProperties.getProperty("map.baidu.key", "XoZYVVPR337Ot2AOBfUqLEum");
    private static final String GEO_CODER_URL = "http://api.map.baidu.com/geocoding/v3/?ak=" + KEY + "&output=json&address=%s";
    private static final String IP_URL = "http://api.map.baidu.com/location/ip?ak=" + KEY + "&coor=bd09ll&ip=%s";
    private static final String COORDS_URL = "http://api.map.baidu.com/reverse_geocoding/v3/?ak=" + KEY + "&output=json&coordtype=wgs84ll&location=";

    public static Coords getCoords(String address) {
        return BaiduMapUtils.getCoords(null, address);
    }

    public static Coords getCoords(String city, String address) {
        Coords coords = null;
        if (address == null || "".equals(address)) {
            address = city;
        }
        if (StringUtils.isNullOrEmpty(city) && StringUtils.isNullOrEmpty(address)) {
            return coords;
        }
        if (city != null && !"".equals(city) && city.indexOf("\u5e02") == -1) {
            city = city + "\u5e02";
        }
        try {
            String url = String.format(GEO_CODER_URL, URLEncoder.encode(address, "utf-8"));
            if (!StringUtils.isNullOrEmpty(city)) {
                url = url + "&city=" + city;
            }
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject result = response.getJSONObject("result");
                JSONObject location = result.getJSONObject("location");
                coords = new Coords();
                coords.setLongitude(location.getDouble("lng"));
                coords.setLatitude(location.getDouble("lat"));
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return coords;
    }

    public static Location getLocation(HttpServletRequest request) {
        return BaiduMapUtils.getLocation(IpAddressUtils.getIpAddress(request));
    }

    public static Location getLocation(String ip) {
        try {
            String url = String.format(IP_URL, ip);
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject content = response.getJSONObject("content");
                Location location = new Location();
                Coords coords = new Coords(content.getJSONObject("point").getDouble("x"), content.getJSONObject("point").getDouble("y"));
                JSONObject addressDetail = content.getJSONObject("address_detail");
                location.setProvince(addressDetail.getString("province"));
                location.setCity(addressDetail.getString("city"));
                location.setDistrict(addressDetail.getString("district"));
                location.setCoords(coords);
                return location;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public static Location getLocation(Coords coords) {
        try {
            String url = COORDS_URL + coords.getLatitude() + "," + coords.getLongitude();
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject result = response.getJSONObject("result");
                Location location = new Location();
                location.setCoords(coords);
                JSONObject addressDetail = result.getJSONObject("addressComponent");
                location.setProvince(addressDetail.getString("province"));
                location.setCity(addressDetail.getString("city"));
                location.setDistrict(addressDetail.getString("district"));
                location.setStreet(addressDetail.getString("street"));
                if (result.containsKey((Object)"formatted_address")) {
                    location.setAddress(result.getString("formatted_address"));
                }
                return location;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

