/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Increment;
import com.crawler.config.JacksonObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    public static Object getFieldValue(Object object, String fieldName) throws NoSuchFieldException {
        Field field = BeanUtils.getDeclaredField(object, fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws NoSuchFieldException {
        Field field = BeanUtils.getDeclaredField(object, fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Field getDeclaredField(Object object, String fieldName) throws NoSuchFieldException {
        Assert.notNull((Object)object);
        return BeanUtils.getDeclaredField(object.getClass(), fieldName);
    }

    public static Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Assert.notNull((Object)clazz);
        Assert.hasText((String)fieldName);
        Class superClass = clazz;
        try {
            return superClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException localNoSuchFieldException) {
            while ((superClass = superClass.getSuperclass()) != Object.class) {
            }
            throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + fieldName);
        }
    }

    @Deprecated
    public static <T> Increment<T> transfer(Increment<?> increment, Class<T> clazz, String ... ignoreProperties) {
        return BeanUtils.convert(increment, clazz, ignoreProperties);
    }

    public static <T> Increment<T> convert(Increment<?> increment, Class<T> clazz, String ... ignoreProperties) {
        if (increment == null) {
            return null;
        }
        Increment<T> newIncrement = new Increment<T>();
        List<T> items = BeanUtils.convert(increment.getItems(), clazz, ignoreProperties);
        newIncrement.setTotalCount(increment.getTotalCount());
        newIncrement.setItems(items);
        return newIncrement;
    }

    @Deprecated
    public static <T> List<T> transfer(List<?> list, Class<T> clazz, String ... ignoreProperties) {
        return BeanUtils.convert(list, clazz, ignoreProperties);
    }

    public static <T> List<T> convert(List<?> list, Class<T> clazz, String ... ignoreProperties) {
        if (list == null) {
            return null;
        }
        ArrayList<T> items = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            items.add(BeanUtils.convert(list.get(i), clazz, ignoreProperties));
        }
        return items;
    }

    public static <T> T convert(Object object, Class<T> clazz, String ... ignoreProperties) {
        if (object == null) {
            return null;
        }
        try {
            T item = clazz.newInstance();
            org.springframework.beans.BeanUtils.copyProperties((Object)object, item, (String[])ignoreProperties);
            return item;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Deprecated
    public static <T> T transfer(Object object, Class<T> clazz, String ... ignoreProperties) {
        return BeanUtils.convert(object, clazz, ignoreProperties);
    }

    public static void update(Object target, Object source) {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)target, (String)"Target must not be null");
        Assert.notNull((Object)source, (String)"Source must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = org.springframework.beans.BeanUtils.getPropertyDescriptors(actualEditable)) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = org.springframework.beans.BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable) throws BeansException {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, editable);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public static String toJSONString(Object object) {
        if (object != null) {
            JacksonObjectMapper objectMapper = new JacksonObjectMapper();
            try {
                return objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return "";
    }

    public static <T> T parse(String value, Class<T> clazz) {
        return BeanUtils.parse(value, clazz, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    public static <T> List<T> parseList(String value, Class<T> clazz) {
        return BeanUtils.parseList(value, clazz, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    public static <T> T parse(String value, Class<T> clazz, PropertyNamingStrategy propertyNamingStrategy) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        objectMapper.setPropertyNamingStrategy(propertyNamingStrategy);
        try {
            return (T)objectMapper.readValue(value, clazz);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> List<T> parseList(String value, Class<T> clazz, PropertyNamingStrategy propertyNamingStrategy) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        objectMapper.setPropertyNamingStrategy(propertyNamingStrategy);
        List list = new ArrayList();
        try {
            list = (List)objectMapper.readValue(value, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, clazz));
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return list;
    }
}

