/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.TimeDuration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class DateUtils {
    private static SimpleDateFormat longFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM");
    private static SimpleDateFormat monthFormat = new SimpleDateFormat("MM");

    public static String getMonthBegin(String strdate) {
        Date date = DateUtils.StringToDate(strdate);
        return DateUtils.formatDate(date, "yyyy-MM") + "-01";
    }

    public static String getMonthEnd(String strdate) {
        Date date = DateUtils.StringToDate(DateUtils.getMonthBegin(strdate));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(6, -1);
        return DateUtils.formatDate(calendar.getTime());
    }

    public static int getMonthDaynum(String strdate) {
        String enddate = DateUtils.getMonthEnd(strdate);
        return Integer.parseInt(enddate.substring(enddate.length() - 2, enddate.length()));
    }

    public static String getWeekBegin(String strDate) {
        Date date = DateUtils.StringToDate(strDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        dayOfWeek = dayOfWeek == 1 ? 6 : (dayOfWeek -= 2);
        calendar.add(6, 0 - dayOfWeek);
        return DateUtils.formatDate(calendar.getTime());
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd");
    }

    public static boolean isSameMinute(Date d1, Date d2) {
        boolean result = d1.getTime() - d2.getTime() >= 60000L || d1.getTime() - d2.getTime() < -60000L ? false : d1.getMinutes() == d2.getMinutes();
        return result;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatMinute(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm");
    }

    @Deprecated
    public static String formatDateByFormat(Date date, String format) {
        return DateUtils.formatDate(date, format);
    }

    public static String formatDate(Date date, String format) {
        String result = "";
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String getYearNow() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(now);
    }

    public static String getMonthNow() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        return sdf.format(now);
    }

    public static String getDateNow() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        return sdf.format(now);
    }

    public static String DateToString(Date date) {
        String strTemp = "";
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            strTemp = formatter.format(date);
        }
        return strTemp;
    }

    @Deprecated
    public static Date StringToDate(String strDate) {
        if (strDate != null && !strDate.equals("")) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                return formatter.parse(strDate);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Date stringToDate(String strDate) {
        if (strDate != null && !strDate.equals("")) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                return formatter.parse(strDate);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Date getPreDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        return new Date(calendar.getTime().getTime());
    }

    public static Date getYesterdayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return new Date(calendar.getTime().getTime());
    }

    public static String getPreMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return monthFormat.format(calendar.getTime());
    }

    public static String getPreMonthStr(String strDate) {
        Date fromDate = DateUtils.StringToDate(strDate);
        Date toDate = DateUtils.getPreDate(fromDate);
        return DateUtils.DateToString(toDate);
    }

    public static int getWeekOfMonth(String strDate) {
        Date date = DateUtils.StringToDate(strDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(4);
    }

    public static String getQueryDate(String date) {
        Date d = DateUtils.StringToDate(date);
        return DateUtils.formatDate(DateUtils.getDateAfter(d, 1));
    }

    public static Date getDateAfter(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        Date newdate = calendar.getTime();
        return newdate;
    }

    public static String getLongNow() {
        Calendar calendar = Calendar.getInstance();
        return longFormat.format(calendar.getTime());
    }

    public static Date getDateByLongFormat(String str) {
        if (str == null || str.length() < 1) {
            return null;
        }
        Date result = null;
        try {
            result = longFormat.parse(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getLongTime(long time) {
        return longFormat.format(time);
    }

    public static String getNow() {
        Calendar calendar = Calendar.getInstance();
        return dateFormat.format(calendar.getTime());
    }

    public static String getYearMonth() {
        Calendar calendar = Calendar.getInstance();
        return shortFormat.format(calendar.getTime());
    }

    public static int getHour() {
        Calendar calendars = Calendar.getInstance();
        int hour = calendars.get(11);
        return hour;
    }

    public static String getYesterday() {
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(6, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(calendar.getTime());
    }

    public static String getYesterdayMonth() {
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(6, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(calendar.getTime());
    }

    public static int getYearCount(Date date, Date date2) {
        int count = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        int year = Integer.parseInt(sdf.format(date));
        int cyear = Integer.parseInt(sdf.format(date2));
        count = cyear - year - 1;
        count = count < 0 ? 0 : count;
        return count;
    }

    public static String getChineseDateStr(String strdate) {
        Date date = DateUtils.StringToDate(strdate);
        String[] datearr = strdate.split("-");
        String[] week = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        String s = datearr[0] + "\u5e74" + datearr[1] + "\u6708" + datearr[2] + "\u65e5  \u661f\u671f";
        int weekday = date.getDay();
        return s + week[weekday];
    }

    public static String getChineseDateStr2(String strdate) {
        String[] datearr = strdate.split("-");
        if (datearr[1].startsWith("0")) {
            datearr[1] = datearr[1].substring(1, datearr[1].length());
        }
        String s = datearr[1] + "\u6708" + datearr[2] + "\u65e5 ";
        return s;
    }

    public static String getChineseDateStr3(String strdate) {
        String[] datearr = strdate.split("-");
        String s = datearr[0] + "\u5e74" + datearr[1] + "\u6708" + datearr[2] + "\u65e5 ";
        return s;
    }

    public static String[] getAllWeekStr(int year) {
        String[] result = new String[]{"", ""};
        String firstday = String.valueOf(year) + "-01-01";
        String lastday = String.valueOf(year) + "-12-31";
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(3, 1);
        Calendar d = (Calendar)c.clone();
        c.set(7, 1);
        if (dateFormat.format(new Date(c.getTimeInMillis())).equals(firstday)) {
            result[0] = result[0] + firstday + "|";
            result[1] = result[1] + firstday + "|";
        }
        c.add(6, 1);
        d.set(7, 7);
        d.add(6, 1);
        String weekmonday = dateFormat.format(new Date(c.getTimeInMillis()));
        String weeksunday = dateFormat.format(new Date(d.getTimeInMillis()));
        result[0] = weekmonday.compareTo(firstday) > 0 ? result[0] + weekmonday + "|" : result[0] + firstday + "|";
        result[1] = result[1] + weeksunday + "|";
        weekmonday = firstday;
        while (weekmonday.startsWith(String.valueOf(year))) {
            c.add(6, 7);
            weekmonday = dateFormat.format(new Date(c.getTimeInMillis()));
            if (!weekmonday.startsWith(String.valueOf(year))) break;
            result[0] = result[0] + weekmonday + "|";
        }
        while (weeksunday.startsWith(String.valueOf(year))) {
            d.add(6, 7);
            weeksunday = dateFormat.format(new Date(d.getTimeInMillis()));
            if (!weeksunday.startsWith(String.valueOf(year))) {
                result[1] = result[1] + lastday + "|";
                break;
            }
            result[1] = result[1] + weeksunday + "|";
            if (!weeksunday.equals(lastday)) continue;
        }
        result[0] = result[0].substring(0, result[0].length() - 1);
        result[1] = result[1].substring(0, result[1].length() - 1);
        return result;
    }

    public static String[] getYearMonthDay() {
        String[] result = new String[3];
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int month = c.get(2) + 1;
        int day = c.get(5);
        result[1] = month < 10 ? String.valueOf("0" + month) : String.valueOf(month);
        result[2] = day < 10 ? String.valueOf("0" + day) : String.valueOf(day);
        result[0] = String.valueOf(c.get(1));
        return result;
    }

    public static long getCurrTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getPrevOrNextMonthTime(int differenceMonth) {
        String time = longFormat.format(DateUtils.getPrevOrNextMonthDate(differenceMonth));
        return time;
    }

    public static Date getPrevOrNextMonthDate(int differenceMonth) {
        Calendar c = Calendar.getInstance();
        c.add(2, differenceMonth);
        return c.getTime();
    }

    public static int compare(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal2.getTime().compareTo(cal1.getTime());
    }

    public static int compare(Date date) {
        return DateUtils.compare(new Date(), date);
    }

    public static int yearDiff(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal2.get(1) - cal1.get(1);
    }

    public static boolean isMonthDiff() {
        String yesterDayMonth;
        String nowMonth = DateUtils.formatDate(new Date(), "yyyy-MM");
        return !nowMonth.equals(yesterDayMonth = DateUtils.getYesterdayMonth());
    }

    public static boolean isSameDate(long time1, long time2) {
        if (String.valueOf(time1).length() == 10) {
            time1 *= 1000L;
        }
        if (String.valueOf(time2).length() == 10) {
            time2 *= 1000L;
        }
        String time1Str = dateFormat.format(new Date(time1));
        String time2Str = dateFormat.format(new Date(time2));
        return time1Str.equals(time2Str);
    }

    public static boolean isSameDate(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        String time1Str = dateFormat.format(date1);
        String time2Str = dateFormat.format(date2);
        return time1Str.equals(time2Str);
    }

    public static String formatLongToDate(long time) {
        if (String.valueOf(time).length() == 10) {
            time *= 1000L;
        }
        return dateFormat.format(new Date(time));
    }

    public static Date toDate(String source, String pattern) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.parse(source);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String toString(Date date, String pattern) {
        return DateUtils.toString(date, pattern, null);
    }

    public static String toString(Date date) {
        Date now = new Date();
        long diff = (long)Math.floor((now.getTime() - date.getTime()) / 60000L);
        if (diff < 1L) {
            return "\u521a\u521a";
        }
        if (diff < 60L) {
            return diff + "\u5206\u949f\u524d";
        }
        if (diff < 1440L) {
            int hours = (int)Math.floor(diff / 60L);
            return hours + "\u5c0f\u65f6\u524d";
        }
        if (DateUtils.isSameYear(date, now)) {
            return DateUtils.formatDate(date, "MM-dd HH:mm");
        }
        return DateUtils.formatDate(date, "yy-MM-dd HH:mm");
    }

    public static String toString(Date date, String pattern, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date isoToDate(String source) {
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        if (source.endsWith("Z")) {
            pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        return DateUtils.toDate(source, pattern);
    }

    public static String toIsoDate(Date date) {
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        return DateUtils.toString(date, pattern);
    }

    public static String getTodayString() {
        return DateUtils.getDateString(new Date());
    }

    public static String getDateString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getLongDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(new Date());
    }

    public static String getDateString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(new Date());
    }

    public static String getDateString(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date());
    }

    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7);
    }

    public static int getDaysBetween(Date fromDate, Date toDate) {
        return (int)((toDate.getTime() - fromDate.getTime()) / 86400000L);
    }

    public static Date getAfter(Date baseDate, int days) {
        return DateUtils.after(baseDate, 86400000L * (long)days);
    }

    public static Date after(Date baseDate, long millsSeconds) {
        Date date = new Date();
        date.setTime(baseDate.getTime() + millsSeconds);
        return date;
    }

    public static Date before(Date baseDate, long millsSeconds) {
        Date date = new Date();
        date.setTime(baseDate.getTime() - millsSeconds);
        return date;
    }

    public static Date afterByHours(Date baseDate, int hours) {
        return DateUtils.after(baseDate, hours * 60 * 60 * 1000);
    }

    public static long toMillsSeconds(String time) {
        String[] arr = time.split(":");
        if (arr.length != 2) {
            return 0L;
        }
        return (Integer.parseInt(arr[0]) * 60 + Integer.parseInt(arr[1])) * 60 * 1000;
    }

    public static long getDayTime() {
        return new Date().getTime() - DateUtils.getToday().getTime();
    }

    public static long dateline() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static String getShortDate() {
        SimpleDateFormat sim = new SimpleDateFormat("yyyyMMdd");
        return sim.format(new Date());
    }

    public static int getAge(String birthday, String unit) {
        if (birthday != null && !"".equals(birthday)) {
            try {
                Date date = DateUtils.toDate(birthday, "yyyy-MM-dd");
                return DateUtils.getAge(date, unit);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public static int getAge(String birthday) {
        return DateUtils.getAge(birthday, "year");
    }

    public static int getAge(Date birthday, String unit) {
        if (birthday != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(birthday);
            int birthYear = calendar.get(1);
            int birthMonth = calendar.get(2);
            int birthDay = calendar.get(5);
            calendar.setTime(new Date());
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            if ("month".equalsIgnoreCase(unit)) {
                int age = (year - birthYear) * 12 + month - birthMonth;
                if (day < birthDay) {
                    --age;
                }
                if (age < 0) {
                    age = 0;
                }
                return age;
            }
            int age = year - birthYear;
            if (month < birthMonth) {
                --age;
            } else if (month == birthMonth && day < birthDay) {
                --age;
            }
            if (age < 0) {
                age = 0;
            }
            return age;
        }
        return 0;
    }

    public static int getAge(Date birthday) {
        return DateUtils.getAge(birthday, "year");
    }

    public static String getAgeByMonth(Date birthday) {
        int num = DateUtils.getAge(birthday, "month");
        int years = num / 12;
        int months = num % 12;
        String label = "";
        if (years > 0) {
            label = label + years + "\u5c81";
        }
        if (months > 0) {
            label = label + months + "\u4e2a\u6708";
        }
        if ("".equals(label)) {
            label = "0\u4e2a\u6708";
        }
        return label;
    }

    public static TimeDuration getDuration(Date baseTime, String begin, String end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(baseTime);
        calendar.set(13, 0);
        calendar.set(14, 0);
        String[] beginArr = begin.split(":");
        calendar.set(11, Integer.parseInt(beginArr[0]));
        calendar.set(12, Integer.parseInt(beginArr[1]));
        Date beginTime = calendar.getTime();
        String[] endArr = end.split(":");
        calendar.set(11, Integer.parseInt(endArr[0]));
        calendar.set(12, Integer.parseInt(endArr[1]));
        Date endTime = calendar.getTime();
        if (!endTime.after(beginTime)) {
            endTime = DateUtils.getAfter(endTime, 1);
        }
        TimeDuration duration = new TimeDuration(beginTime, endTime);
        return duration;
    }

    public static String getYesterdayString(String pattern) {
        Date yesterday = DateUtils.getAfter(DateUtils.getToday(), -1);
        return DateUtils.toString(yesterday, pattern);
    }

    public static boolean isSameYear(Date src, Date dest) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        int srcYear = calendar.get(1);
        calendar.setTime(dest);
        int destYear = calendar.get(1);
        return srcYear == destYear;
    }

    public static Date afterToday(int days) {
        Date today = DateUtils.getToday();
        return DateUtils.getAfter(today, days);
    }

    public static Date getDateByWeekday(Date date, Integer weekday) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, weekday + 1);
        Date newDate = calendar.getTime();
        if (newDate.before(date)) {
            newDate = DateUtils.getAfter(newDate, 7);
        }
        return newDate;
    }

    public static Date customToDate(String str) {
        str = str.trim();
        Date now = new Date();
        Random random = new Random();
        String timeStr = str.replaceAll("[^\\d]", "");
        if ("".equals(timeStr)) {
            timeStr = String.valueOf(random.nextInt(60));
        }
        long time = Long.parseLong(timeStr);
        if (str.contains("\u5206\u949f")) {
            time *= (long)(60 + random.nextInt(60));
        } else if (str.contains("\u5c0f\u65f6")) {
            time = time * (long)(60 + random.nextInt(60)) * 60L;
        } else if (str.contains("\u5929")) {
            time = time * (long)(24 + random.nextInt(24)) * 60L * 60L;
        } else if (str.contains("\u5e74")) {
            time = time * (long)(365 + random.nextInt(365)) * 24L * 60L * 60L;
        }
        return DateUtils.before(now, time * 1000L);
    }

    public static String getConstellation(int month, int day) {
        int[] days = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
        String[] texts = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7"};
        int index = month - 1;
        return day < days[index] ? texts[index] : texts[(index + 1) % 12];
    }

    public static String getConstellation(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getConstellation(calendar.get(2) + 1, calendar.get(5));
    }

    public static String getConstellation(String birthday) {
        if (birthday == null) {
            return null;
        }
        Date date = DateUtils.StringToDate(birthday);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getConstellation(calendar.get(2) + 1, calendar.get(5));
    }

    public static Date toSimpleDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

