/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.config.PropertiesLoader;
import com.crawler.exception.SimpleRuntimeException;
import com.crawler.utils.DateUtils;
import com.crawler.utils.StringUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsClient {
    private static Logger logger = LoggerFactory.getLogger(SmsClient.class);
    private static PropertiesLoader loader = new PropertiesLoader("sms.properties");
    private static final String SIGN = loader.getProperty("sms.sign", "");
    private static final String SMS_SERVER_URL = loader.getProperty("sms.url");
    private static final String CUST_CODE = loader.getProperty("sms.cust_code");
    private static final String PASSWORD = loader.getProperty("sms.password");
    private static final String SP_CODE = loader.getProperty("sms.sp_code");

    public static String send(String phone, String content) {
        try {
            String result = SmsClient.sendSms(phone, content);
            System.out.println(DateUtils.getLongNow() + " => \u77ed\u4fe1\u53d1\u9001\u7ed3\u679c\uff1a" + result);
            if (!result.toUpperCase().startsWith("SUCCESS")) {
                throw new SimpleRuntimeException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            }
            return result;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new SimpleRuntimeException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
    }

    public static String sendSms(String mobiles, String content) throws IOException {
        return SmsClient.sendSms(mobiles, content, SP_CODE, 0L);
    }

    public static String sendSms(String mobiles, String content, long task_id) throws IOException {
        return SmsClient.sendSms(mobiles, content, SP_CODE, task_id);
    }

    public static String sendSms(String mobiles, String content, String sp_code) throws IOException {
        return SmsClient.sendSms(mobiles, content, sp_code, 0L);
    }

    public static String sendSms(String mobiles, String content, String sp_code, long task_id) throws IOException {
        if (SIGN != null && !"".equals(SIGN)) {
            content = "\u3010" + SIGN + "\u3011" + content;
        }
        String urlencContent = URLEncoder.encode(content, "utf-8");
        String sign = StringUtils.md5(urlencContent + PASSWORD);
        String postData = "content=" + urlencContent + "&destMobiles=" + mobiles + "&sign=" + sign + "&cust_code=" + CUST_CODE + "&sp_code=" + sp_code + "&task_id=" + task_id;
        logger.info(postData);
        URL myurl = new URL(SMS_SERVER_URL);
        URLConnection urlc = myurl.openConnection();
        urlc.setReadTimeout(30000);
        urlc.setDoOutput(true);
        urlc.setDoInput(true);
        urlc.setAllowUserInteraction(false);
        DataOutputStream server = new DataOutputStream(urlc.getOutputStream());
        server.write(postData.getBytes("utf-8"));
        server.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream(), "utf-8"));
        String result = "";
        String s = "";
        while ((s = in.readLine()) != null) {
            result = result + s + "\r\n";
        }
        in.close();
        return result;
    }
}

