/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Coords;
import com.crawler.beans.Location;
import com.crawler.config.ConfigProperties;
import com.crawler.http.SimpleHttpClient;
import com.crawler.utils.IpAddressUtils;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentMapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TencentMapUtils.class);
    private static final String KEY = ConfigProperties.getProperty("map.tencent.key", "JKGBZ-GJXCO-FMPWM-SD7GJ-JEGGV-TABXR");
    private static final String GEO_CODER_URL = "https://apis.map.qq.com/ws/geocoder/v1/?key=" + KEY + "&address=";
    private static final String IP_URL = "https://apis.map.qq.com/ws/location/v1/ip?key=" + KEY + "&ip=";
    private static final String COORDS_URL = "https://apis.map.qq.com/ws/geocoder/v1/?key=" + KEY + "&location=";

    public static Coords getCoords(String address) {
        return TencentMapUtils.getCoords(null, address);
    }

    public static Coords getCoords(String city, String address) {
        Coords coords = null;
        try {
            String url = GEO_CODER_URL + URLEncoder.encode(address, "utf-8");
            if (city != null && !"".equals(city)) {
                url = url + "&region=" + city;
            }
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject result = response.getJSONObject("result");
                JSONObject location = result.getJSONObject("location");
                coords = new Coords();
                coords.setLongitude(location.getDouble("lng"));
                coords.setLatitude(location.getDouble("lat"));
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return coords;
    }

    public static Location getLocation(HttpServletRequest request) {
        return TencentMapUtils.getLocation(IpAddressUtils.getIpAddress(request));
    }

    public static Location getLocation(String ip) {
        try {
            String url = IP_URL + ip;
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject content = response.getJSONObject("result");
                Location location = new Location();
                Coords coords = new Coords(content.getJSONObject("location").getDouble("lng"), content.getJSONObject("location").getDouble("lat"));
                JSONObject addressDetail = content.getJSONObject("ad_info");
                location.setProvince(addressDetail.getString("province"));
                location.setCity(addressDetail.getString("city"));
                location.setDistrict(addressDetail.getString("district"));
                location.setCoords(coords);
                return location;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public static Location getLocation(Coords coords) {
        try {
            String url = COORDS_URL + coords.getLatitude() + "," + coords.getLongitude();
            JSONObject response = JSONObject.fromObject((Object)SimpleHttpClient.get(url));
            LOGGER.info("\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, (Object)response);
            if (response.containsKey((Object)"status") && response.getInt("status") == 0) {
                JSONObject result = response.getJSONObject("result");
                Location location = new Location();
                location.setCoords(coords);
                JSONObject addressDetail = result.getJSONObject("address_component");
                location.setProvince(addressDetail.getString("province"));
                location.setCity(addressDetail.getString("city"));
                location.setDistrict(addressDetail.getString("district"));
                location.setStreet(addressDetail.getString("street"));
                location.setAddress(result.getString("address"));
                return location;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

