/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.ZipItem;
import com.crawler.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ZipUtils {
    private static Logger logger = LoggerFactory.getLogger(ZipUtils.class);
    private static final String CHINESE_CHARSET = "GBK";
    private static final int CACHE_SIZE = 1024;

    public static File unzip(MultipartFile multipartFile, String basePath) throws IllegalStateException, IOException {
        String path = basePath + "/" + System.currentTimeMillis() + StringUtils.getRandomString(8);
        String fileName = path + ".zip";
        File file = new File(fileName);
        file.createNewFile();
        multipartFile.transferTo(file);
        File directory = new File(path);
        directory.mkdirs();
        ZipUtils.unzip(file.getAbsolutePath(), path + "/");
        file.delete();
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        ZipFile zipFile = null;
        try {
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
            Enumeration zipEntries = zipFile.getEntries();
            byte[] cache = new byte[1024];
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)zipEntries.nextElement();
                if (entry.isDirectory()) {
                    new File(path + entry.getName()).mkdirs();
                    continue;
                }
                try {
                    bis = new BufferedInputStream(zipFile.getInputStream(entry));
                    File file = new File(path + entry.getName());
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 1024);
                    int readIndex = 0;
                    while ((readIndex = bis.read(cache, 0, 1024)) != -1) {
                        fos.write(cache, 0, readIndex);
                    }
                    ((BufferedOutputStream)bos).flush();
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (bis == null) continue;
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream compress(String resourcesPath) throws Exception {
        File resourcesFile = new File(resourcesPath);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream((OutputStream)new BufferedOutputStream(byteArrayOutputStream));
            ZipUtils.createCompressedFile(out, resourcesFile, "");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCompressedFile(ZipOutputStream out, File file, String dir) throws Exception {
        block13: {
            block11: {
                block12: {
                    if (dir == null) {
                        dir = "";
                    }
                    if (!file.isDirectory()) break block11;
                    File[] files = file.listFiles();
                    if (files.length <= 0) break block12;
                    dir = "".equals(dir) ? "" : dir + "/";
                    for (int i = 0; i < files.length; ++i) {
                        ZipUtils.createCompressedFile(out, files[i], dir + files[i].getName());
                    }
                    break block13;
                }
                if ("".equals(dir)) break block13;
                out.putNextEntry(new ZipEntry(dir + "/"));
                break block13;
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(dir));
                int count = 0;
                byte[] buffer = new byte[1024];
                while ((count = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream createCompressedFile(List<ZipItem> zipItems) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream));
            for (ZipItem zipItem : zipItems) {
                if (zipItem.isFile()) {
                    out.putNextEntry(new ZipEntry(zipItem.getPath()));
                    int count = 0;
                    byte[] buffer = new byte[1024];
                    while ((count = zipItem.getInputStream().read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                    continue;
                }
                out.putNextEntry(new ZipEntry(zipItem.getPath() + "/"));
            }
            out.flush();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return outputStream;
    }
}

