package com.crawler.excel;

import java.util.ArrayList;
import java.util.List;

/**
 * Excel Bean
 * @author yanglize
 *
 */
public class ExcelBean {
    
    private String name;
    
    private String sheetName;
    
    private ExcelTitle[] titles;
    
    private List<String[]> dataList;
    
    private boolean headBold = true;
    
    /**
     * 列宽 （像素）
     */
    private int columnWidth = 200;
    
    private int rowHeight = 20;
    
    public ExcelBean(String name, String sheetName, ExcelTitle[] titles){
        this.name = name;
        this.sheetName = sheetName;
        this.titles = titles;
        this.dataList = new ArrayList<String[]>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public ExcelTitle[] getTitles() {
		return titles;
	}

	public void setTitles(ExcelTitle[] titles) {
		this.titles = titles;
	}

	public List<String[]> getDataList() {
        return dataList;
    }

    public void setDataList(List<String[]> dataList) {
        this.dataList = dataList;
    }
    
    public boolean isHeadBold() {
        return headBold;
    }

    public void setHeadBold(boolean headBold) {
        this.headBold = headBold;
    }

    public int getColumnWidth() {
        return columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getRowHeight() {
		return rowHeight;
	}

	public void setRowHeight(int rowHeight) {
		this.rowHeight = rowHeight;
	}

	public void add(String[] data){
        this.dataList.add(data);
    }
	
	public void add(Object ... objects){
		int len = objects.length;
		String[] data = new String[len];
		for(int i=0; i<len; i++){
			data[i] = String.valueOf(objects[i]);
		}
		this.dataList.add(data);
	}
    

}
