package com.crawler.excel;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

/**
 * excel 图片
 * @author yanglizhe
 *
 */
public class ExcelImage {
	private int width;
	
	private int height;
	
	private byte[] byteArray;
	
	public ExcelImage(String imageUrl) throws IOException{
		BufferedImage bufferedImage = ImageIO.read(new URL(imageUrl));
    	ByteArrayOutputStream byteArrayOutputStream =new ByteArrayOutputStream();
    	ImageIO.write(bufferedImage,"png", byteArrayOutputStream);
    	width = bufferedImage.getWidth();
    	height = bufferedImage.getHeight();
    	byteArray = byteArrayOutputStream.toByteArray();
    	byteArrayOutputStream.close();
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public byte[] getByteArray() {
		return byteArray;
	}

	public void setByteArray(byte[] byteArray) {
		this.byteArray = byteArray;
	}
}
