package com.crawler.utils;

import java.util.HashMap;

import com.crawler.config.ConfigProperties;
import com.crawler.http.SimpleHttpClient;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;


/**
 * 物流工具
 * @author rubekid
 *
 * 2017年3月23日 下午3:40:10
 */
public class LogisticsUtils {

	/**
	 * 物流公司默认JSON
	 */
	private static final String COMPANY_DEFALUT_JSON = "{\"gsm\":{\"site\":\"http://www.gsmnton.com \",\"name\":\"GSM快递\",\"tel\":\"021-64656011 \",\"key\":\"gsm\"},\"xinbang\":{\"site\":\"http://www.xbwl.cn\",\"name\":\"新邦物流\",\"tel\":\"4008-000-222\",\"key\":\"xinbang\"},\"zhongsukuaidi\":{\"site\":\"http://www.ems.com.cn/mainservice/ems/zhong_su_guo_ji_kuai_jian.html\",\"name\":\"中速快件查询\",\"tel\":\"11183\",\"key\":\"zhongsukuaidi\"},\"shlindao\":{\"site\":\"http://www.ldxpress.com/\",\"name\":\"上海林道货运查询\",\"tel\":\"4008-200-112\",\"key\":\"shlindao\"},\"yuanfeihangwuliu\":{\"site\":\"http://www.yfhex.com\",\"name\":\"原飞航物流\",\"tel\":\"0769-87001100\",\"key\":\"yuanfeihangwuliu\"},\"dywl\":{\"site\":\"http://www.dayang365.cn\",\"name\":\"大洋物流\",\"tel\":\"400-820-0088\",\"key\":\"dywl\"},\"kuayue\":{\"site\":\"http://www.ky-express.com/\",\"name\":\"跨越速运\",\"tel\":\"4008-098-098 \",\"key\":\"kuayue\"},\"axd\":{\"site\":\"http://www.anxinda.com\",\"name\":\"安信达快递\",\"tel\":\"021-54224681\",\"key\":\"axd\"},\"yxwl\":{\"site\":\"http://www.yx56.cn\",\"name\":\"宇鑫物流\",\"tel\":\"0371-66378798/99\",\"key\":\"yxwl\"},\"dsukuaidi\":{\"site\":\"http://www.d-exp.cn\",\"name\":\"D速物流单号查询\",\"tel\":\"0531-88636363\",\"key\":\"dsukuaidi\"},\"huiqiang\":{\"site\":\"http://www.hq-ex.com\",\"name\":\"汇强快递\",\"tel\":\"400-000-0177\",\"key\":\"huiqiang\"},\"dpex\":{\"site\":\"http://www.szdpex.com.cn\",\"name\":\"DPEX快递\",\"tel\":\"021-64659883\",\"key\":\"dpex\"},\"meiguo\":{\"site\":\"http://www.us-ex.com\",\"name\":\"美国快递\",\"tel\":\"888-611-1888\",\"key\":\"meiguo\"},\"yunda\":{\"site\":\"http://www.yundaex.com\",\"name\":\"韵达快递\",\"tel\":\"400-821-6789\",\"key\":\"yunda\"},\"hswl\":{\"site\":\"http://www.hs-express.cn\",\"name\":\"昊盛物流\",\"tel\":\"400-186-5566\",\"key\":\"hswl\"},\"guada\":{\"site\":\"http://www.gda-e.com.cn/\",\"name\":\"冠达快递\",\"tel\":\"400-990-0088\",\"key\":\"guada\"},\"xindan\":{\"site\":\"http://www.ozzo.com.cn\",\"name\":\"新蛋物流\",\"tel\":\"400-820-4400\",\"key\":\"xindan\"},\"gdems\":{\"site\":\"http://www.gdems.com/\",\"name\":\"广东ems快递\",\"tel\":\"11183\",\"key\":\"gdems\"},\"menduimen\":{\"site\":\"http://www.szdod.com\",\"name\":\"门对门查询\",\"tel\":\"400-700-7676\",\"key\":\"menduimen\"},\"chengji\":{\"site\":\"http://chengji-express.com/\",\"name\":\"城际快递\",\"tel\":\"4000-523-525\",\"key\":\"chengji\"},\"shenghuiwuliu\":{\"site\":\"http://www.shenghui56.com\",\"name\":\"盛辉物流查询\",\"tel\":\"4008-222-222\",\"key\":\"shenghuiwuliu\"},\"yousu\":{\"site\":\"http://www.uc56.com\",\"name\":\"优速快递\",\"tel\":\"400-1111-119\",\"key\":\"yousu\"},\"minbangsudi\":{\"site\":\"http://www.mbex168.com/\",\"name\":\"民邦速递查询\",\"tel\":\"0769-81515303\",\"key\":\"minbangsudi\"},\"ocs\":{\"site\":\"http://www.ocschina.com\",\"name\":\"OCS快递\",\"tel\":\"400-118-8588\",\"key\":\"ocs\"},\"yitongda\":{\"site\":\"http://www.etd365.com/\",\"name\":\"易通达\",\"tel\":\"0898-65339299\",\"key\":\"yitongda\"},\"xianglongyuntong\":{\"site\":\"http://www.ldl.com.cn\",\"name\":\"祥龙运通快递\",\"tel\":\"4008-908-908\",\"key\":\"xianglongyuntong\"},\"yzjc\":{\"site\":\"http://www.yjkd.com\",\"name\":\"元智捷诚快递\",\"tel\":\"400-081-2345\",\"key\":\"yzjc\"},\"cxwl\":{\"site\":\"http://www.cxcod.com\",\"name\":\"传喜物流\",\"tel\":\"400-777-5656\",\"key\":\"cxwl\"},\"jiayiwuliu\":{\"site\":\"http://www.jiayi56.com/\",\"name\":\"佳怡物流\",\"tel\":\"400-631-9999\",\"key\":\"jiayiwuliu\"},\"ctwl\":{\"site\":\"http://www.hnct56.com\",\"name\":\"长通物流\",\"tel\":\"0731-6652 0111\",\"key\":\"ctwl\"},\"aj\":{\"site\":\"http://www.anjelex.com/index.asp\",\"name\":\"安捷快递\",\"tel\":\"400-056-5656\",\"key\":\"aj\"},\"gsdwl\":{\"site\":\"http://www.gongsuda.com\",\"name\":\"共速达物流\",\"tel\":\"400-111-0005\",\"key\":\"gsdwl\"},\"suijiawuliu\":{\"site\":\"http://www.suijiawl.com\",\"name\":\"穗佳物流\",\"tel\":\"400-880-9771\",\"key\":\"suijiawuliu\"},\"jietekuaidi\":{\"site\":\"http://www.jet185.com/\",\"name\":\"捷特快递\",\"tel\":\"400-820-8585\",\"key\":\"jietekuaidi\"},\"gls\":{\"site\":\"http://www.gls-group.net\",\"name\":\"GLS快递\",\"tel\":\"877-914-5465\",\"key\":\"gls\"},\"chuanzhi\":{\"site\":\"http://www.chuanzhi.cn\",\"name\":\"传志快递\",\"tel\":\"上海(021-56325555 56625555) 北京(010-67035843) 广州(020-86380996)\",\"key\":\"chuanzhi\"},\"rrs\":{\"site\":\"http://www.rrs.com/\",\"name\":\"日日顺物流\",\"tel\":\"400-999-999\",\"key\":\"rrs\"},\"yuntongkuaidi\":{\"site\":\"http://www.ytkd168.com\",\"name\":\"运通快递单号查询\",\"tel\":\"0769-81156999\",\"key\":\"yuntongkuaidi\"},\"fedex\":{\"site\":\"http://fedex.com/cn\",\"name\":\"FEDEX国际快递\",\"tel\":\"400-886-1888\",\"key\":\"fedex\"},\"xlyt\":{\"site\":\"http://www.ldl.com.cn/\",\"name\":\"祥龙运通\",\"tel\":\"4008-908-908\",\"key\":\"xlyt\"},\"yibang\":{\"site\":\"http://www.ebon-express.com/\",\"name\":\"一邦快递\",\"tel\":\"4008-000-666\",\"key\":\"yibang\"},\"ups\":{\"site\":\"http://www.ups.com/cn\",\"name\":\"UPS国际快递\",\"tel\":\"400-820-8388\",\"key\":\"ups\"},\"yuefeng\":{\"site\":\"http://www.yfexpress.com.hk\",\"name\":\"越丰快递\",\"tel\":\"852-23909969\",\"key\":\"yuefeng\"},\"jd\":{\"site\":\"http://www.jdwl.com/\",\"name\":\"京东快递查询\",\"tel\":\"400-603-3600\",\"key\":\"jd\"},\"tnt\":{\"site\":\"http://www.tnt.com.cn\",\"name\":\"TNT快递\",\"tel\":\"800-820-9868\",\"key\":\"tnt\"},\"shengfeng\":{\"site\":\"http://www.sfwl.com.cn\",\"name\":\"盛丰物流\",\"tel\":\"0591-83621111\",\"key\":\"shengfeng\"},\"zhongyouwuliu\":{\"site\":\"http://www.cnpl.com.cn\",\"name\":\"中邮物流查询\",\"tel\":\"11183\",\"key\":\"zhongyouwuliu\"},\"fkd\":{\"site\":\"http://www.fkd.com.cn\",\"name\":\"飞康达快递\",\"tel\":\"010-84223376,010-84223378\",\"key\":\"fkd\"},\"wxwl\":{\"site\":\"http://www.ewinshine.com\",\"name\":\"万象物流\",\"tel\":\"400-820-8088\",\"key\":\"wxwl\"},\"zjs\":{\"site\":\"http://www.zjs.com.cn\",\"name\":\"宅急送快递\",\"tel\":\"400-6789-000\",\"key\":\"zjs\"},\"aae\":{\"site\":\"http://cn.aaeweb.com\",\"name\":\"AAE快递\",\"tel\":\"400-610-0400\",\"key\":\"aae\"},\"quanyikuaidi\":{\"site\":\"http://www.unitop-apex.com/\",\"name\":\"全一快递单号查询\",\"tel\":\"400-663-1111\",\"key\":\"quanyikuaidi\"},\"yilingsuyun\":{\"site\":\"http://www.yelee.com.cn/\",\"name\":\"亿领速运\",\"tel\":\"400-1056-400\",\"key\":\"yilingsuyun\"},\"henglu\":{\"site\":\"http://www.e-henglu.com\",\"name\":\"恒路物流\",\"tel\":\"400-182-6666\",\"key\":\"henglu\"},\"weibang\":{\"site\":\"http://www.scsexpress.com/?char_set=gb\",\"name\":\"伟邦快递\",\"tel\":\"021-64212098/021-62629520\",\"key\":\"weibang\"},\"zzjh\":{\"site\":\"http://www.zzjhtd.com\",\"name\":\"郑州建华快递\",\"tel\":\"0371-65995266\",\"key\":\"zzjh\"},\"dtwl\":{\"site\":\"http://www.dtw.com.cn\",\"name\":\"大田物流\",\"tel\":\"010-59237777\",\"key\":\"dtwl\"},\"weitepai\":{\"site\":\"http://www.vtepai.com\",\"name\":\"微特派快递\",\"tel\":\"400-606-0909\",\"key\":\"weitepai\"},\"yuantong\":{\"site\":\"http://www.yto.net.cn\",\"name\":\"圆通快递\",\"tel\":\"021-69777888/999\",\"key\":\"yuantong\"},\"jiayunmei\":{\"site\":\"http://www.tms56.com\",\"name\":\"加运美快递\",\"tel\":\"0769-8551-5555\",\"key\":\"jiayunmei\"},\"krwl\":{\"site\":\"http://www.krwl-sh.com/\",\"name\":\"宽容物流\",\"tel\":\"400-820-2719\",\"key\":\"krwl\"},\"lianhaowuliu\":{\"site\":\"http://www.lhtex.com.cn\",\"name\":\"联昊通快递查询\",\"tel\":\"400-8888887\",\"key\":\"lianhaowuliu\"},\"kangliwuliu\":{\"site\":\"http://www.kangliex.com/\",\"name\":\"康力物流\",\"tel\":\"400-156-5156 \",\"key\":\"kangliwuliu\"},\"quanyi\":{\"site\":\"http://www.unitop-apex.com\",\"name\":\"全一快递\",\"tel\":\"400-663-1111\",\"key\":\"quanyi\"},\"jywl\":{\"site\":\"http://www.jiayi56.com\",\"name\":\"佳怡物流\",\"tel\":\"400-660-5656\",\"key\":\"jywl\"},\"zhongtie\":{\"site\":\"http://www.ztky.com \",\"name\":\"中铁快运\",\"tel\":\"400-000-5566\",\"key\":\"zhongtie\"},\"disifang\":{\"site\":\"http://www.4px.com\",\"name\":\"递四方查询\",\"tel\":\"0755-33933895\",\"key\":\"disifang\"},\"nuoyaao\":{\"site\":\"http://www.royaleinternational.com/\",\"name\":\"偌亚奥国际快递\",\"tel\":\"4008 871 871\",\"key\":\"nuoyaao\"},\"debang\":{\"site\":\"http://www.deppon.com\",\"name\":\"德邦物流\",\"tel\":\"400-830-5555\",\"key\":\"debang\"},\"gjbg\":{\"site\":\"http://intmail.183.com.cn/\",\"name\":\"国际包裹\",\"tel\":\"11183\",\"key\":\"gjbg\"},\"yuananda\":{\"site\":\"http://www.yadex.com.cn\",\"name\":\"源安达快递查询\",\"tel\":\"0769-85157789\",\"key\":\"yuananda\"},\"pinganda\":{\"site\":\"http://www.padtf.com\",\"name\":\"平安达快递\",\"tel\":\"4006-230-009\",\"key\":\"pinganda\"},\"huitong\":{\"site\":\"http://www.htky365.com\",\"name\":\"汇通快递\",\"tel\":\"021-62963636\",\"key\":\"huitong\"},\"yad\":{\"site\":\"http://www.yadex.com.cn/\",\"name\":\"源安达快递\",\"tel\":\"0769-85021875\",\"key\":\"yad\"},\"feiyang\":{\"site\":\"www.express.shipgce.com\",\"name\":\"飞洋快递\",\"tel\":\"1-877-387-9799 / 626-527-5800\",\"key\":\"feiyang\"},\"huaxialongwuliu\":{\"site\":\"http://www.chinadragon56.com\",\"name\":\"华夏龙物流\",\"tel\":\"400-716-6133\",\"key\":\"huaxialongwuliu\"},\"jldt\":{\"site\":\"http://www.kerryeas.com\",\"name\":\"嘉里大通物流\",\"tel\":\"400-610-3188\",\"key\":\"jldt\"},\"wanjiawuliu\":{\"site\":\"http://www.manco-logistics.com/\",\"name\":\"万家物流单号查询\",\"tel\":\"4001-156-561\",\"key\":\"wanjiawuliu\"},\"saiaodi\":{\"site\":\"http://www.51cod.com \",\"name\":\"赛澳递\",\"tel\":\"4000-345-888\",\"key\":\"saiaodi\"},\"ycwl\":{\"site\":\"http://www.ycgwl.com\",\"name\":\"远成物流\",\"tel\":\"400-820-1646\",\"key\":\"ycwl\"},\"rufengda\":{\"site\":\"http://www.rufengda.com\",\"name\":\"如风达快递\",\"tel\":\"400-010-6660\",\"key\":\"rufengda\"},\"dhl\":{\"site\":\"http://www.cn.dhl.com\",\"name\":\"DHL快递\",\"tel\":\"800-810-8000\",\"key\":\"dhl\"},\"yishunhang\":{\"site\":\"http://www.igoex.com/\",\"name\":\"亿顺航快递\",\"tel\":\"4006-018-268 \",\"key\":\"yishunhang\"},\"jialidatong\":{\"site\":\"http://www.kerryeas.com\",\"name\":\"嘉里大通查询\",\"tel\":\"400-610-3188\",\"key\":\"jialidatong\"},\"zhongtong\":{\"site\":\"http://www.zto.cn\",\"name\":\"中通快递\",\"tel\":\"021-39777777\",\"key\":\"zhongtong\"},\"cs\":{\"site\":\"http://www.bjcs100.com\",\"name\":\"城市100快递\",\"tel\":\"010-52932760\",\"key\":\"cs\"},\"fanyukuaidi\":{\"site\":\"http://www.fanyu56.com.cn/\",\"name\":\"凡宇速递\",\"tel\":\"4006-580-358 \",\"key\":\"fanyukuaidi\"},\"feibaokuaidi\":{\"site\":\"http://www.ztky.com/feibao/KJCX.aspx\",\"name\":\"飞豹快递\",\"tel\":\"400-000-5566\",\"key\":\"feibaokuaidi\"},\"xinfengwuliu\":{\"site\":\"http://www.xf-express.com.cn\",\"name\":\"信丰快递查询\",\"tel\":\"400-830-6333\",\"key\":\"xinfengwuliu\"},\"coe\":{\"site\":\"http://www.coe.com.hk\",\"name\":\"东方快递\",\"tel\":\"0755-83575000\",\"key\":\"coe\"},\"lanhu\":{\"site\":\"http://www.lanhukd.com/\",\"name\":\"蓝狐快递\",\"tel\":\"4000661646\",\"key\":\"lanhu\"},\"santai\":{\"site\":\"http://www.sfcservice.com\",\"name\":\"三态速递\",\"tel\":\"400-881-8106\",\"key\":\"santai\"},\"xfwl\":{\"site\":\"http://www.xf-express.com.cn\",\"name\":\"信丰物流\",\"tel\":\"400-830-6333\",\"key\":\"xfwl\"},\"ddwl\":{\"site\":\"http://www.idada56.com/\",\"name\":\"大达物流\",\"tel\":\"400-098-5656\",\"key\":\"ddwl\"},\"shentong\":{\"site\":\"http://www.sto.cn\",\"name\":\"申通快递\",\"tel\":\"400-889-5543\",\"key\":\"shentong\"},\"cszx\":{\"site\":\"http://www.socl.net\",\"name\":\"城市之星物流\",\"tel\":\"400-628-5168\",\"key\":\"cszx\"},\"yinjiesudi\":{\"site\":\"www.sjfd-express.com\",\"name\":\"银捷速递查询\",\"tel\":\"0755-88999000\",\"key\":\"yinjiesudi\"},\"tiantian\":{\"site\":\"http://www.ttkdex.com\",\"name\":\"天天快递\",\"tel\":\"400-820-8198\",\"key\":\"tiantian\"},\"minshengkuaidi\":{\"site\":\"http://www.xmms-express.com/\",\"name\":\"闽盛快递\",\"tel\":\"0592-3725988\",\"key\":\"minshengkuaidi\"},\"jingdong\":{\"site\":\"http://jd-ex.com/\",\"name\":\"京东快递\",\"tel\":\"400-603-3600\",\"key\":\"jingdong\"},\"jinyue\":{\"site\":\"http://www.byondex.com\",\"name\":\"晋越快递\",\"tel\":\"0769-85158039\",\"key\":\"jinyue\"},\"feibao\":{\"site\":\"http://www.ztky.com/feibao/KJCX.aspx\",\"name\":\"飞豹快递\",\"tel\":\"400-000-5566\",\"key\":\"feibao\"},\"balunzhi\":{\"site\":\"http://cnbd.hendari.com/\",\"name\":\"巴伦支快递\",\"tel\":\"400-885-6561\",\"key\":\"balunzhi\"},\"wanbo\":{\"site\":\"http://www.wanboex.cn\",\"name\":\"万博快递\",\"tel\":\"0311-83035553\",\"key\":\"wanbo\"},\"huaqikuaiyun\":{\"site\":\"http://www.hqkd.cn/\",\"name\":\"华企快运\",\"tel\":\"400-806-8111\",\"key\":\"huaqikuaiyun\"},\"jinguangsudikuaijian\":{\"site\":\"http://www.szkke.com/\",\"name\":\"京广快递查询\",\"tel\":\"0769-88629888\",\"key\":\"jinguangsudikuaijian\"},\"haoshengwuliu\":{\"site\":\"http://www.hs-express.cn/\",\"name\":\"昊盛物流\",\"tel\":\"400-186-5566\",\"key\":\"haoshengwuliu\"},\"ds\":{\"site\":\"http://www.d-exp.cn\",\"name\":\"D速快递\",\"tel\":\"0531-88636363\",\"key\":\"ds\"},\"zhongtiewuliu\":{\"site\":\"http://www.cre.cn \",\"name\":\"中铁快运单号查询\",\"tel\":\"95572\",\"key\":\"zhongtiewuliu\"},\"haihong\":{\"site\":\"http://www.haihongwangsong.com\",\"name\":\"山东海红快递\",\"tel\":\"400-632-9988\",\"key\":\"haihong\"},\"meilong\":{\"site\":\"http://www.mjexp.com/\",\"name\":\"美龙快递\",\"tel\":\"323-208-9848\",\"key\":\"meilong\"},\"chuanxiwuliu\":{\"site\":\"http://www.cxcod.com/\",\"name\":\"传喜物流\",\"tel\":\"400-777-5656 \",\"key\":\"chuanxiwuliu\"},\"yuefengwuliu\":{\"site\":\"http://www.yfexpress.com.hk\",\"name\":\"越丰快递查询\",\"tel\":\"852-23909969\",\"key\":\"yuefengwuliu\"},\"fengxingtianxia\":{\"site\":\"http://www.fxtxsy.com\",\"name\":\"风行天下\",\"tel\":\"4000-404-909\",\"key\":\"fengxingtianxia\"},\"santaisudi\":{\"site\":\"http://www.sfcservice.com/\",\"name\":\"三态速递查询\",\"tel\":\"400-881-8106  \",\"key\":\"santaisudi\"},\"bgpyghx\":{\"site\":\"http://yjcx.chinapost.com.cn\",\"name\":\"包裹、平邮、挂号信\",\"tel\":\"11185\",\"key\":\"bgpyghx\"},\"fanyu\":{\"site\":\"http://www.fanyu56.com.cn\",\"name\":\"凡宇快递\",\"tel\":\"400-658-0358\",\"key\":\"fanyu\"},\"ztwy\":{\"site\":\"http://www.wanyun56.cn\",\"name\":\"中天万运快递\",\"tel\":\"0531-68850629\",\"key\":\"ztwy\"},\"fedexcn\":{\"site\":\"http://cndxp.apac.fedex.com\",\"name\":\"FEDEX国内快递\",\"tel\":\"400-886-1888\",\"key\":\"fedexcn\"},\"zhongruisudi\":{\"site\":\"http://www.zorel.cn/\",\"name\":\"中睿速递\",\"tel\":\"400-0375-888\",\"key\":\"zhongruisudi\"},\"zhengzhoujianhua\":{\"site\":\"http://www.zzjhtd.com/\",\"name\":\"郑州建华\",\"tel\":\"0371-65995266\",\"key\":\"zhengzhoujianhua\"},\"shengfengwuliu\":{\"site\":\"http://www.sfwl.com.cn\",\"name\":\"盛丰物流查询\",\"tel\":\"0591-83621111\",\"key\":\"shengfengwuliu\"},\"mingliangwuliu\":{\"site\":\"http://www.szml56.com/\",\"name\":\"明亮物流\",\"tel\":\"400-035-6568\",\"key\":\"mingliangwuliu\"},\"guotong\":{\"site\":\"http://www.gto365.com\",\"name\":\"国通快递\",\"tel\":\"4006-773-777\",\"key\":\"guotong\"},\"sevendays\":{\"site\":\"http://www.92856.cn\",\"name\":\"7天连锁物流\",\"tel\":\"400-882-1202\",\"key\":\"sevendays\"},\"jingguang\":{\"site\":\"http://www.kke.com.hk\",\"name\":\"京广快递\",\"tel\":\"0769-83660666-60\",\"key\":\"jingguang\"},\"tcwl\":{\"site\":\"http://www.tc56.com\",\"name\":\"通成物流\",\"tel\":\"021-36161199-8021\",\"key\":\"tcwl\"},\"lejiedi\":{\"site\":\"http://www.ljd360.com\",\"name\":\"乐捷递快递\",\"tel\":\"400-618-1400\",\"key\":\"lejiedi\"},\"shenghui\":{\"site\":\"http://www.shenghui56.com\",\"name\":\"盛辉物流\",\"tel\":\"4008-222-222\",\"key\":\"shenghui\"},\"dayangwuliu\":{\"site\":\"http://www.dayang365.cn/\",\"name\":\"大洋物流快递\",\"tel\":\"400-820-0088\",\"key\":\"dayangwuliu\"},\"dsf\":{\"site\":\"http://www.4px.com\",\"name\":\"递四方速递\",\"tel\":\"0755-33933895\",\"key\":\"dsf\"},\"minhang\":{\"site\":\"http://www.cae.com.cn\",\"name\":\"民航快递\",\"tel\":\"400-817-4008\",\"key\":\"minhang\"},\"shiyun\":{\"site\":\"http://www.sehoex.com/\",\"name\":\"世运快递\",\"tel\":\"400-666-1111\",\"key\":\"shiyun\"},\"tdhy\":{\"site\":\"http://www.hoau.net\",\"name\":\"天地华宇\",\"tel\":\"400-808-6666\",\"key\":\"tdhy\"},\"tonghetianxia\":{\"site\":\"http://www.cod56.com\",\"name\":\"通和天下\",\"tel\":\"400-0056-516 \",\"key\":\"tonghetianxia\"},\"suer\":{\"site\":\"http://www.sure56.com\",\"name\":\"速尔快递\",\"tel\":\"400-882-2168\",\"key\":\"suer\"},\"baifudongfang\":{\"site\":\"http://www.ees.com.cn\",\"name\":\"百福东方物流\",\"tel\":\"400-706-0609\",\"key\":\"baifudongfang\"},\"fbwl\":{\"site\":\"http://121.14.118.50:8050\",\"name\":\"飞邦物流\",\"tel\":\"0769-89066698\",\"key\":\"fbwl\"},\"jixianda\":{\"site\":\"http://www.joust.net.cn/\",\"name\":\"急先达物流\",\"tel\":\"021-59766363\",\"key\":\"jixianda\"},\"hxlwl\":{\"site\":\"http://www.chinadragon56.com\",\"name\":\"华夏龙物流\",\"tel\":\"0755-61211999\",\"key\":\"hxlwl\"},\"stwl\":{\"site\":\"http://www.sut56.com/\",\"name\":\"速通物流\",\"tel\":\"4006561185\",\"key\":\"stwl\"},\"jiayunmeiwuliu\":{\"site\":\"http://www.jym56.cn/\",\"name\":\"加运美快递查询\",\"tel\":\"0769-85515555\",\"key\":\"jiayunmeiwuliu\"},\"yafeng\":{\"site\":\"http://www.broad-asia.net\",\"name\":\"亚风快递\",\"tel\":\"400-628-0018\",\"key\":\"yafeng\"},\"klwl\":{\"site\":\"http://www.kangliex.com\",\"name\":\"康力物流\",\"tel\":\"400-156-5156\",\"key\":\"klwl\"},\"zengyi\":{\"site\":\"http://www.zeny-express.com\",\"name\":\"增益快递\",\"tel\":\"4008-456-789\",\"key\":\"zengyi\"},\"jiaji\":{\"site\":\"http://www.jiaji.com\",\"name\":\"佳吉快运\",\"tel\":\"400-820-5566\",\"key\":\"jiaji\"},\"datianwuliu\":{\"site\":\"http://www.dtw.com.cn\",\"name\":\"大田物流\",\"tel\":\"400-626-1166\",\"key\":\"datianwuliu\"},\"jinyuekuaidi\":{\"site\":\"http://www.byondex.com\",\"name\":\"晋越快递查询\",\"tel\":\"400-638-9288\",\"key\":\"jinyuekuaidi\"},\"xiyoutekuaidi\":{\"site\":\"http://www.cod365.com/\",\"name\":\"希优特快递\",\"tel\":\"4008400365\",\"key\":\"xiyoutekuaidi\"},\"bgn\":{\"site\":\"http://www.cuckooexpress.com/\",\"name\":\"布谷鸟快递\",\"tel\":\"400-100-0533\",\"key\":\"bgn\"},\"ems\":{\"site\":\"http://www.ems.com.cn/\",\"name\":\"EMS\",\"tel\":\"11183\",\"key\":\"ems\"},\"lianhaotong\":{\"site\":\"http://www.lhtex.com.cn\",\"name\":\"联昊通快递\",\"tel\":\"0769-88620000\",\"key\":\"lianhaotong\"},\"quanritong\":{\"site\":\"http://www.at-express.com\",\"name\":\"全日通快递\",\"tel\":\"020-86298999\",\"key\":\"quanritong\"},\"anxl\":{\"site\":\"http://www.anxl.com.cn/\",\"name\":\"安迅物流查询\",\"tel\":\"010-59288730\",\"key\":\"anxl\"},\"shangda\":{\"site\":\"http://www.sundapost.net\",\"name\":\"上大物流\",\"tel\":\"400-021-9122\",\"key\":\"shangda\"},\"thtx\":{\"site\":\"http://www.cod56.com\",\"name\":\"通和天下物流\",\"tel\":\"400-0056-516\",\"key\":\"thtx\"},\"gtsd\":{\"site\":\"http://www.hre-e.com/\",\"name\":\"高铁速递\",\"tel\":\"400-999-7777\",\"key\":\"gtsd\"},\"haimengsudi\":{\"site\":\"http://www.hm-express.com\",\"name\":\"海盟速递\",\"tel\":\"400-080-6369 \",\"key\":\"haimengsudi\"},\"bangsongwuliu\":{\"site\":\"http://express.banggo.com\",\"name\":\"邦送物流\",\"tel\":\"021-20965696\",\"key\":\"bangsongwuliu\"},\"longbang\":{\"site\":\"http://www.lbex.com.cn\",\"name\":\"龙邦快递\",\"tel\":\"021-39283333\",\"key\":\"longbang\"},\"hebeijianhua\":{\"site\":\"http://116.255.133.172/hebeiwebsite/index.jsp\",\"name\":\"河北建华\",\"tel\":\"0311-86123186\",\"key\":\"hebeijianhua\"},\"gznd\":{\"site\":\"http://www.nd56.com\",\"name\":\"港中能达\",\"tel\":\"400-620-1111\",\"key\":\"gznd\"},\"feihu\":{\"site\":\"http://www.feihukuaidi.com\",\"name\":\"飞狐快递\",\"tel\":\"010-51389299\",\"key\":\"feihu\"},\"lijisong\":{\"site\":\"http://www.cdljs.com\",\"name\":\"立即送\",\"tel\":\"400-028-5666\",\"key\":\"lijisong\"},\"kuaijie\":{\"site\":\"http://www.fastexpress.com.cn\",\"name\":\"快捷快递\",\"tel\":\"400-830-4888\",\"key\":\"kuaijie\"},\"youbijia\":{\"site\":\"http://www.ubjia.com/\",\"name\":\"邮必佳快递\",\"tel\":\"400-687-8123\",\"key\":\"youbijia\"},\"fengda\":{\"site\":\"http://www.fd168.com.cn\",\"name\":\"丰达快递\",\"tel\":\"400-113-6666\",\"key\":\"fengda\"},\"zhongyou\":{\"site\":\"http://www.cnpl.com.cn\",\"name\":\"中邮物流\",\"tel\":\"11183\",\"key\":\"zhongyou\"},\"guangtong\":{\"site\":\"http://www.gtongsudi.com/\",\"name\":\"广通速递\",\"tel\":\"400-080-6369\",\"key\":\"guangtong\"},\"bfdf\":{\"site\":\"http://www.ees.com.cn\",\"name\":\"百福东方\",\"tel\":\"010-57169000\",\"key\":\"bfdf\"},\"quanfeng\":{\"site\":\"http://www.qfkd.com.cn\",\"name\":\"全峰快递\",\"tel\":\"400-100-0001\",\"key\":\"quanfeng\"},\"yuxinwuliu\":{\"site\":\"http://www.yx56.cn/\",\"name\":\"宇鑫物流\",\"tel\":\"0371-66368798\",\"key\":\"yuxinwuliu\"},\"zmkm\":{\"site\":\"http://www.zmkmex.com\",\"name\":\"芝麻开门\",\"tel\":\"4001-056-056,88056056\",\"key\":\"zmkm\"},\"chengguang\":{\"site\":\"http://www.flyway.co.nz\",\"name\":\"程光快递\",\"tel\":\"0064 9 948 2780\",\"key\":\"chengguang\"},\"pingandatengfei\":{\"site\":\"http://www.padtf.com/\",\"name\":\"平安达腾飞快递\",\"tel\":\"4009-990-998\",\"key\":\"pingandatengfei\"},\"anwl\":{\"site\":\"http://www.ane56.com/\",\"name\":\"安能物流\",\"tel\":\"40010-40088\",\"key\":\"anwl\"},\"shengan\":{\"site\":\"http://www.sa56.net\",\"name\":\"圣安物流\",\"tel\":\"4006-618-169\",\"key\":\"shengan\"},\"shunfeng\":{\"site\":\"http://www.sf-express.com\",\"name\":\"顺丰快递\",\"tel\":\"400-811-1111\",\"key\":\"shunfeng\"},\"wanxiangwuliu\":{\"site\":\"http://www.ewinshine.com\",\"name\":\"万象物流\",\"tel\":\"400-820-8088\",\"key\":\"wanxiangwuliu\"},\"yuanfeihang\":{\"site\":\"http://www.yfhex.com\",\"name\":\"原飞航快递\",\"tel\":\"0755-29778899\",\"key\":\"yuanfeihang\"},\"zhongwaiyun\":{\"site\":\"http://www.sinoex.com.cn/index.aspx\",\"name\":\"中外运速递查询\",\"tel\":\"010-8041 8611\",\"key\":\"zhongwaiyun\"},\"neweggozzo\":{\"site\":\"http://www.ozzo.com.cn\",\"name\":\"新蛋物流\",\"tel\":\"400-820-4400\",\"key\":\"neweggozzo\"},\"minbang\":{\"site\":\"http://www.ywfex.com\",\"name\":\"民邦快递\",\"tel\":\"0769-81515303\",\"key\":\"minbang\"},\"yuntong\":{\"site\":\"http://www.ytkd168.com\",\"name\":\"运通快递\",\"tel\":\"0769-81156999\",\"key\":\"yuntong\"},\"huaqi\":{\"site\":\"http://www.hqkd.cn/\",\"name\":\"华企快递\",\"tel\":\"400-806-8111\",\"key\":\"huaqi\"},\"quanchen\":{\"site\":\"http://www.qckd.net\",\"name\":\"全晨快递\",\"tel\":\"0769-82026703\",\"key\":\"quanchen\"},\"newl\":{\"site\":\"http://www.nell.cn/\",\"name\":\"尼尔物流\",\"tel\":\"400-000-5611\",\"key\":\"newl\"},\"minghangkuaidi\":{\"site\":\"http://www.cae.com.cn\",\"name\":\"民航快递查询\",\"tel\":\"400-817-4008\",\"key\":\"minghangkuaidi\"},\"quanchenkuaidi\":{\"site\":\"http://www.qckd.net/\",\"name\":\"全晨快递查询\",\"tel\":\"0769-82026703\",\"key\":\"quanchenkuaidi\"},\"youzhengguonei\":{\"site\":\"http://yjcx.chinapost.com.cn/\",\"name\":\"邮政快递\",\"tel\":\"11183\",\"key\":\"youzhengguonei\"},\"kuaijiesudi\":{\"site\":\"http://www.kjkd.com/\",\"name\":\"快捷速递\",\"tel\":\"4008-333-666\",\"key\":\"kuaijiesudi\"},\"huitongkuaidi\":{\"site\":\"http://www.800bestex.com/\",\"name\":\"百世快递\",\"tel\":\"95320\",\"key\":\"huitongkuaidi\"},\"zhaijisong\":{\"site\":\"http://www.zjs.com.cn\",\"name\":\"宅急送\",\"tel\":\"400-6789-000\",\"key\":\"zhaijisong\"},\"guotongkuaidi\":{\"site\":\"http://www.gto365.com\",\"name\":\"国通快递\",\"tel\":\"95327\",\"key\":\"guotongkuaidi\"}}";
	
	/**
	 * 帐号
	 */
    private static final String CUSTOMER = ConfigProperties.getProperty("kuaidi100.customer", "6C08040BBA46F5EAB2AF6B139691036A");
    
    /**
     * KEY
     */
    private static final String KEY = ConfigProperties.getProperty("kuaidi100.key", "hnAeEkKQ1864");
    
    /**
     * 快递公司信息
     */
    private static JSONObject COMPANY_MAP = JSONObject.fromObject(ConfigProperties.getProperty("logistics.company", "{}"));
    
    /**
     * 自动单号查询
     */
    private static final String AUTONUMBER_URL = "http://www.kuaidi100.com/autonumber/auto?key=%s&num=%s";
    
    /**
     * 物流查询
     */
    private static final String QUERY_URL = "http://poll.kuaidi100.com/poll/query.do";
    
    static{
    	if(COMPANY_MAP == null){
    		COMPANY_MAP = new JSONObject();
    	}
    	JSONObject data = JSONObject.fromObject(COMPANY_DEFALUT_JSON);
    	for(Object key : COMPANY_MAP.keySet()){
    		data.put(key, COMPANY_MAP.get(key));
    	}
    	COMPANY_MAP = data;
    }

    /**
     * 获取物流
     * @param num
     * @return
     */
    public static JSONObject getExpressInfo(String num){
    	JSONObject result = new JSONObject();
        try {
            String url = String.format(AUTONUMBER_URL, KEY, num);
            JSONArray array = SimpleHttpClient.getForObject(url, JSONArray.class);
            if(array != null && array.size() > 0){
            	result = getExpressInfo(array.getJSONObject(0).get("comCode").toString(), num);
            }
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
    
    public static JSONObject getExpressInfo(String com, String num) throws Exception{
    	String param ="{\"com\":\""+ com +"\",\"num\":\""+num+"\"}";
        String sign = StringUtils.md5(param+KEY+CUSTOMER).toUpperCase();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param",param);
        params.put("sign",sign);
        params.put("customer",CUSTOMER);
        String resp = SimpleHttpClient.post(QUERY_URL, params, null);
        JSONObject json = JSONObject.fromObject(resp);
        if(COMPANY_MAP.containsKey(com)){
        	JSONObject company = COMPANY_MAP.getJSONObject(com);
        	json.put("company", company);
        }
        return json;
    }
    
    public static void main(String[] args) {
		getExpressInfo("700395238598");
	}
}
