package com.crawler.utils;

import java.util.regex.Pattern;

import com.crawler.exception.SimpleRuntimeException;

/**
 * 参数校验器
 * @author rubekid
 * 2016年12月1日
 */
public class ParamenterChecker {

	/**
	 * 不能为Null
	 * @param object
	 * @param message
	 */
	public static void notNull(Object object, String message){
		if(object == null){
			throw new SimpleRuntimeException(message);
		}
	}
	
	/**
	 * 不能为空
	 * @param string
	 * @param message
	 */
	public static void notEmptyOrNull(String string, String message){
		if(isEmptyOrNull(string)){
			throw new SimpleRuntimeException(message);
		}
	}
	
	/**
	 * 是否为空
	 * @param string
	 */
	public static boolean isEmptyOrNull(String string){
		if(string == null || "".equals(string.trim())){
			return true;
		}
		return false;
	}
	
	
	/**
	 * 不能为空
	 * @param number
	 * @param message
	 */
	public static void notEmptyOrZero(Number number, String message){
		if(isEmptyOrZero(number)){
			throw new SimpleRuntimeException(message);
		}
	}
	
	/**
	 * 判断是否为空或0
	 * @param number
	 * @param message
	 * @return
	 */
	public static boolean isEmptyOrZero(Number number){
		if(number == null || number.doubleValue() == 0D){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断是否含有汉字
	 * @param string
	 */
	public static boolean containChinese(String string){
		Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
		return pattern.matcher(string).find();
	}
	
	/**
	 * 判断是否含有空格
	 */
	public static boolean containBlank(String string){
		Pattern pattern = Pattern.compile("[\\s]");
		return pattern.matcher(string).find(); 
	}
	
	/**
	 * 判断是否为电话号码
	 */
	public static boolean isPhone(String string){
		Pattern pattern = Pattern.compile("1[3,4,5,7,8]\\d{9}");
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断是否为手机号码
	 */
	public static boolean isMobile(String string){
		Pattern pattern = Pattern.compile("1[3,4,5,7,8]\\d{9}");
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断是否为固定电话
	 */
	public static boolean isTelephone(String string){
		Pattern pattern = Pattern.compile("(^\\+86\\.\\d{3,5}\\d{6,8}$)|(^((0\\d{2,3})-?)(\\d{7,8})(-(\\d{3,}))?$)");
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断是否为邮箱
	 */
	public static boolean isEmail(String string){
		Pattern pattern = Pattern.compile("[&~#$*%\\u4e00-\\u9fa5_0-9a-z\\-\\.\\/\\\\]+@([\\u4e00-\\u9fa5-a-z0-9]+\\.){1,5}[\\u4e00-\\u9fa5a-z]+", Pattern.CASE_INSENSITIVE);
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断是否为链接地址
	 */
	public static boolean isUrl(String string){
		Pattern pattern = Pattern.compile("((http|https):\\/\\/([\\w\\-]+\\.)+[\\w\\-]+(\\/[\\w\\u4e00-\\u9fa5\\-\\.\\/?\\@\\%\\!\\&=\\+\\~\\:\\#\\;\\,]*)?)", Pattern.CASE_INSENSITIVE );
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断是否为域名
	 */
	public static boolean isDomain(String string){
		Pattern pattern = Pattern.compile("^([\\x{4e00}-\\x{9fa5}-a-z0-9]+\\.){1,5}[\\x{4e00}-\\x{9fa5}a-z]+$", Pattern.CASE_INSENSITIVE );
		return pattern.matcher(string).matches();
	}
	
	/**
	 * 判断字符串为null or 空
	 */
	public static boolean isNullOrEmpty(String string){
		return string==null || string.trim().isEmpty();
	}
	
	/**
	 * 检测密码强度
	 */
	public static int checkStrength(String string){
		int strength = 0;
		
		Pattern pattern = Pattern.compile("[a-z]+", Pattern.CASE_INSENSITIVE);
		if (pattern.matcher(string).find()) {
			strength ++;
		}
		pattern = Pattern.compile("[0-9]+", Pattern.CASE_INSENSITIVE);
		if (pattern.matcher(string).find()) {
			strength ++;
		}
		pattern = Pattern.compile("[\\/,.~!@#$%^&*()\\[\\]_+\\-=\\:\";'\\{\\}\\|\\\\><\\?]+", Pattern.CASE_INSENSITIVE);
		if (pattern.matcher(string).find()) {
			strength ++;
		}
		return strength;
	}
	
	/**
	 * 判断是否为数字
	 */
	public static boolean isNumber(String string){
		Pattern pattern = Pattern.compile("^[1-9]\\d*$", Pattern.CASE_INSENSITIVE );
		return "0".equals(string) || pattern.matcher(string).matches();
	}
	
}
