package com.crawler.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

import com.crawler.config.PropertiesLoader;
import com.crawler.exception.SimpleRuntimeException;

public class SmsClient {
	
	/**
	 * 属性文件加载对象
	 */
	private static PropertiesLoader loader = new PropertiesLoader("sms.properties");
	
	private static final String smsSvcUrl = loader.getProperty("sms.url", "http://43.243.130.33:8860");	   //服务器URL 地址
	private static final String cust_code = loader.getProperty("sms.cust_code", "300270");									 //账号
	private static final String password = loader.getProperty("sms.password", "6C7C6CP7ZM");		 								//密码
	private static final String sp_code = loader.getProperty("sms.sp_code", "10690651549951");                  //接入码（扩展码）
	
	/**
	 * 短信发送
	 * @param phone
	 * @param content
	 */
	public static String send(String phone, String content){
		try {
			String result = SmsClient.sendSms(phone, content);
			System.out.println("短信发送结果：" + result);
			return result;
		} catch (IOException e) {
			throw new SimpleRuntimeException("短信发送失败");
		}
	}

	public static String sendSms(String mobiles, String content) throws IOException {
		return sendSms(mobiles, content, sp_code, 0);
	}

	public static String sendSms(String mobiles, String content, long task_id) throws IOException {
		return sendSms(mobiles, content, sp_code, task_id);
	}

	public static String sendSms(String mobiles, String content, String sp_code) throws IOException {
		return sendSms(mobiles, content, sp_code, 0);
	}

	public static String sendSms(String mobiles, String content, String sp_code, long task_id) throws IOException {
		String urlencContent = URLEncoder.encode(content,"utf-8");
        String sign=StringUtils.md5(urlencContent + password);
		String postData = "content=" + urlencContent + "&destMobiles="
				+ mobiles + "&sign=" + sign + "&cust_code=" + cust_code
				+ "&sp_code=" + sp_code + "&task_id=" + task_id;
		System.err.println(postData);
		URL myurl = new URL(smsSvcUrl);
		URLConnection urlc = myurl.openConnection();
		urlc.setReadTimeout(1000 * 30);
		urlc.setDoOutput(true);
		urlc.setDoInput(true);
		urlc.setAllowUserInteraction(false);

		DataOutputStream server = new DataOutputStream(urlc.getOutputStream());

		server.write(postData.getBytes("utf-8"));
		server.close();

		BufferedReader in = new BufferedReader(new InputStreamReader(
				urlc.getInputStream(), "utf-8"));
		String result = "", s = "";
		while ((s = in.readLine()) != null)
			result = result + s + "\r\n";
		in.close();
		return result;
	}
}