/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.component.SpringContextUtil;
import com.crawler.config.ConfigProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class EhCacheManager {
    private static final String EHCACHE_NAME = ConfigProperties.getProperty("ehcache.name");
    private static final CacheManager cacheManager = SpringContextUtil.getBean(CacheManager.class);
    private String prefix = "";
    private String ehcacheName;

    public EhCacheManager() {
        this.ehcacheName = EHCACHE_NAME;
    }

    public EhCacheManager(String prefix) {
        this.prefix = prefix;
    }

    public EhCacheManager(String ehcacheName, String prefix) {
        this.ehcacheName = ehcacheName;
        this.prefix = prefix;
    }

    public <T> T get(String key, Class<T> clazz) {
        Cache cache = cacheManager.getCache(this.ehcacheName);
        Cache.ValueWrapper value = cache.get((Object)(key = String.valueOf(this.prefix) + key));
        if (value == null) {
            return null;
        }
        return (T)value.get();
    }

    public void put(String key, Object value) {
        Cache cache = cacheManager.getCache(this.ehcacheName);
        if (value != null) {
            key = String.valueOf(this.prefix) + key;
            cache.put((Object)key, value);
        }
    }
}

