/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.config.ConfigProperties;
import javax.servlet.http.HttpServletRequest;

public class WebUtils {
    private static final String BASE_URL = ConfigProperties.getProperty("site.url");

    public static String getBaseUrl(HttpServletRequest request) {
        String baseUrl = BASE_URL;
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = request.getRequestURL().toString().replace(request.getRequestURI(), "");
        }
        return baseUrl;
    }

    public static String getUrl(HttpServletRequest request) {
        String url = String.valueOf(request.getProtocol()) + " ://" + request.getServerName();
        if (request.getServerPort() != 80) {
            url = String.valueOf(url) + ":" + request.getServerPort();
        }
        url = String.valueOf(url) + request.getContextPath() + request.getServletPath() + "?" + request.getQueryString();
        return url;
    }

    public static String getBasePath(HttpServletRequest request) {
        String url = String.valueOf(request.getScheme()) + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            url = String.valueOf(url) + ":" + request.getServerPort();
        }
        url = String.valueOf(url) + request.getContextPath();
        return url;
    }
}

