/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.config;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProperties {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProperties.class);
    private static Properties properties;
    private static Properties defaultProperties;

    static {
        defaultProperties = new Properties();
        try {
            properties = new Properties(defaultProperties);
            InputStream stream = ConfigProperties.class.getClassLoader().getResourceAsStream("config.properties");
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (Exception ex) {
            logger.warn("Read config.properties error.", (Throwable)ex);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static int getPropertyForInteger(String key) {
        String value = ConfigProperties.getProperty(key);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = ConfigProperties.getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = ConfigProperties.getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a boolean \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }
}

