/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.exception.SimpleRuntimeException;
import java.util.regex.Pattern;

public class ParamenterChecker {
    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new SimpleRuntimeException(message);
        }
    }

    public static void notEmptyOrNull(String string, String message) {
        if (ParamenterChecker.isEmptyOrNull(string)) {
            throw new SimpleRuntimeException(message);
        }
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || "".equals(string.trim());
    }

    public static void notEmptyOrZero(Number number, String message) {
        if (ParamenterChecker.isEmptyOrZero(number)) {
            throw new SimpleRuntimeException(message);
        }
    }

    public static boolean isEmptyOrZero(Number number) {
        return number == null || number.doubleValue() == 0.0;
    }

    public static boolean containChinese(String string) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        return pattern.matcher(string).find();
    }

    public static boolean containBlank(String string) {
        Pattern pattern = Pattern.compile("[\\s]");
        return pattern.matcher(string).find();
    }

    public static boolean isPhone(String string) {
        Pattern pattern = Pattern.compile("1[3,4,5,7,8]\\d{9}");
        return pattern.matcher(string).matches();
    }

    public static boolean isMobile(String string) {
        Pattern pattern = Pattern.compile("1[3,4,5,7,8]\\d{9}");
        return pattern.matcher(string).matches();
    }

    public static boolean isTelephone(String string) {
        Pattern pattern = Pattern.compile("(^\\+86\\.\\d{3,5}\\d{6,8}$)|(^((0\\d{2,3})-?)(\\d{7,8})(-(\\d{3,}))?$)");
        return pattern.matcher(string).matches();
    }

    public static boolean isEmail(String string) {
        Pattern pattern = Pattern.compile("[&~#$*%\\u4e00-\\u9fa5_0-9a-z\\-\\.\\/\\\\]+@([\\u4e00-\\u9fa5-a-z0-9]+\\.){1,5}[\\u4e00-\\u9fa5a-z]+", 2);
        return pattern.matcher(string).matches();
    }

    public static boolean isUrl(String string) {
        Pattern pattern = Pattern.compile("((http|https):\\/\\/([\\w\\-]+\\.)+[\\w\\-]+(\\/[\\w\\u4e00-\\u9fa5\\-\\.\\/?\\@\\%\\!\\&=\\+\\~\\:\\#\\;\\,]*)?)", 2);
        return pattern.matcher(string).matches();
    }

    public static boolean isDomain(String string) {
        Pattern pattern = Pattern.compile("^([\\x{4e00}-\\x{9fa5}-a-z0-9]+\\.){1,5}[\\x{4e00}-\\x{9fa5}a-z]+$", 2);
        return pattern.matcher(string).matches();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static int checkStrength(String string) {
        int strength = 0;
        Pattern pattern = Pattern.compile("[a-z]+", 2);
        if (pattern.matcher(string).find()) {
            ++strength;
        }
        if ((pattern = Pattern.compile("[0-9]+", 2)).matcher(string).find()) {
            ++strength;
        }
        if ((pattern = Pattern.compile("[\\/,.~!@#$%^&*()\\[\\]_+\\-=\\:\";'\\{\\}\\|\\\\><\\?]+", 2)).matcher(string).find()) {
            ++strength;
        }
        return strength;
    }

    public static boolean isNumber(String string) {
        Pattern pattern = Pattern.compile("^[1-9]\\d*$", 2);
        return "0".equals(string) || pattern.matcher(string).matches();
    }
}

