package com.crawler.utils;

import java.util.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.beans.Coords;
import com.crawler.beans.Location;
import com.crawler.config.ConfigProperties;
import com.crawler.http.SimpleHttpClient;

import net.sf.json.JSONObject;

/**
 * 高德地图工具
 *
 * 2019年5月24日 下午2:36:31
 */
public class AmapUtils {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(BaiduMapUtils.class);
	
	/**
	 * KEY
	 */
	private static final String APP_KEY  = ConfigProperties.getProperty("amap.lbs.key", "6fbc337ded79d7af1168c08e60e76802");
	
	/**
	 * IP定位
	 */
	private static final String IP_URL = "https://restapi.amap.com/v3/ip?ip=%s&key=" + APP_KEY;
	
	
	public static Location getLocation(String ip) {
		try{
			String url = String.format(IP_URL, ip);
			JSONObject response = JSONObject.fromObject(SimpleHttpClient.get(url));
			if(response.containsKey("status") && response.getInt("status") ==1){
				
				Location location = new Location();
				location.setProvince(response.getString("province"));
				location.setCity(response.getString("city"));
				String[] arr = response.getString("rectangle").split(";");
				
				String[] point1 = arr[0].split(",");
				Coords coords1 = new Coords(Double.parseDouble(point1[0]), Double.parseDouble(point1[1]));
				
				String[] point2 = arr[1].split(",");
				Coords coords2 = new Coords(Double.parseDouble(point2[0]), Double.parseDouble(point2[1]));
				
				Random random = new Random();
				Coords coords = new Coords(coords1.getLongitude() + random.nextDouble() * (coords2.getLongitude() - coords1.getLongitude()), coords1.getLatitude() + random.nextDouble() * (coords2.getLatitude() - coords1.getLatitude()));
				location.setCoords(coords);
				return location;
			}
		}
		catch(Exception ex){
			LOGGER.error(ex.getMessage(), ex);
		}
		return null;
	}
}
