/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.CategoryNode;
import com.crawler.beans.CategoryTreeNode;
import com.crawler.beans.Node;
import com.crawler.beans.SimpleNode;
import com.crawler.beans.SimpleTreeNode;
import com.crawler.beans.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNodeUtils {
    public static List<TreeNode> generateTree(List<Node> nodes, String rootId) {
        HashMap<String, List<TreeNode>> map = new HashMap<String, List<TreeNode>>();
        for (Node node : nodes) {
            String parentId = node.getParentId();
            List<TreeNode> treeNodes = new ArrayList();
            if (map.containsKey(parentId)) {
                treeNodes = (List)map.get(parentId);
            }
            TreeNode treeNode = new TreeNode();
            treeNode.setId(node.getId());
            treeNode.setName(node.getName());
            treeNode.setImage(node.getImage());
            treeNodes.add(treeNode);
            map.put(parentId, treeNodes);
        }
        return TreeNodeUtils.buildNode(map, rootId);
    }

    private static List<TreeNode> buildNode(Map<String, List<TreeNode>> map, String parentId) {
        List<TreeNode> nodes = map.get(parentId);
        if (nodes != null) {
            for (TreeNode treeNode : nodes) {
                treeNode.setChildren(TreeNodeUtils.buildNode(map, treeNode.getId()));
            }
        }
        return nodes;
    }

    public static List<SimpleTreeNode> generateTree(List<SimpleNode> nodes, Number rootId) {
        HashMap<Number, List<SimpleTreeNode>> map = new HashMap<Number, List<SimpleTreeNode>>();
        for (SimpleNode node : nodes) {
            Number parentId = node.getParentId();
            List<SimpleTreeNode> treeNodes = new ArrayList();
            if (map.containsKey(parentId)) {
                treeNodes = (List)map.get(parentId);
            }
            SimpleTreeNode treeNode = new SimpleTreeNode();
            treeNode.setId(node.getId());
            treeNode.setName(node.getName());
            treeNodes.add(treeNode);
            map.put(parentId, treeNodes);
        }
        return TreeNodeUtils.buildSimpleNode(map, rootId);
    }

    public static List<SimpleTreeNode> generateTree(List<SimpleNode> nodes) {
        return TreeNodeUtils.generateTree(nodes, 0);
    }

    private static List<SimpleTreeNode> buildSimpleNode(Map<Number, List<SimpleTreeNode>> map, Number parentId) {
        List<SimpleTreeNode> nodes = map.get(parentId);
        if (nodes != null) {
            for (SimpleTreeNode treeNode : nodes) {
                treeNode.setChildren(TreeNodeUtils.buildSimpleNode(map, treeNode.getId()));
            }
        }
        return nodes;
    }

    public static List<CategoryTreeNode> genCategoryTree(List<CategoryNode> nodes, Number rootId) {
        HashMap<Number, List<CategoryTreeNode>> map = new HashMap<Number, List<CategoryTreeNode>>();
        for (CategoryNode node : nodes) {
            Number parentId = node.getParentId();
            List<CategoryTreeNode> treeNodes = new ArrayList();
            if (map.containsKey(parentId)) {
                treeNodes = (List)map.get(parentId);
            }
            CategoryTreeNode treeNode = new CategoryTreeNode();
            treeNode.setId(node.getId());
            treeNode.setName(node.getName());
            treeNode.setIcon(node.getIcon());
            treeNodes.add(treeNode);
            map.put(parentId, treeNodes);
        }
        return TreeNodeUtils.buildCategoryNode(map, rootId);
    }

    public static List<CategoryTreeNode> genCategoryTree(List<CategoryNode> nodes) {
        return TreeNodeUtils.genCategoryTree(nodes, 0);
    }

    private static List<CategoryTreeNode> buildCategoryNode(Map<Number, List<CategoryTreeNode>> map, Number parentId) {
        List<CategoryTreeNode> nodes = map.get(parentId);
        if (nodes != null) {
            for (CategoryTreeNode treeNode : nodes) {
                treeNode.setChildren(TreeNodeUtils.buildCategoryNode(map, treeNode.getId()));
            }
        }
        return nodes;
    }
}

