/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.mail;

import com.jeeplus.common.mail.MailAuthenticator;
import com.jeeplus.common.mail.MailBody;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSendUtils {
    public boolean sendTextMail(MailBody mailInfo) throws Exception {
        MailAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MailAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
        mailMessage.setFrom((Address)from);
        InternetAddress to = new InternetAddress(mailInfo.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
        mailMessage.setSubject(mailInfo.getSubject());
        mailMessage.setSentDate(new Date());
        String mailContent = mailInfo.getContent();
        mailMessage.setText(mailContent);
        Transport.send((Message)mailMessage);
        System.out.println("\u53d1\u9001\u6210\u529f\uff01");
        return true;
    }

    public boolean sendHtmlMail(MailBody mailInfo) throws Exception {
        MailAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MailAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
        mailMessage.setFrom((Address)from);
        InternetAddress to = new InternetAddress(mailInfo.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
        mailMessage.setSubject(mailInfo.getSubject());
        mailMessage.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
        mainPart.addBodyPart((BodyPart)html);
        mailMessage.setContent((Multipart)mainPart);
        Transport.send((Message)mailMessage);
        return true;
    }

    public static boolean sendEmail(String SMTP, String PORT, String EMAIL, String PAW, String toEMAIL, String TITLE, String CONTENT, String TYPE) {
        MailBody mailInfo = new MailBody();
        mailInfo.setMailServerHost(SMTP);
        mailInfo.setMailServerPort(PORT);
        mailInfo.setValidate(true);
        mailInfo.setUserName(EMAIL);
        mailInfo.setPassword(PAW);
        mailInfo.setFromAddress(EMAIL);
        mailInfo.setToAddress(toEMAIL);
        mailInfo.setSubject(TITLE);
        mailInfo.setContent(CONTENT);
        MailSendUtils sms = new MailSendUtils();
        try {
            if ("1".equals(TYPE)) {
                return sms.sendTextMail(mailInfo);
            }
            return sms.sendHtmlMail(mailInfo);
        }
        catch (Exception e) {
            return false;
        }
    }
}

