/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.utils.CookieUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class Page<T> {
    protected int pageNo = 1;
    protected int pageSize = Integer.valueOf(Global.getConfig((String)"page.pageSize"));
    protected long count;
    protected int first;
    protected int last;
    protected int prev;
    protected int next;
    private boolean firstPage;
    private boolean lastPage;
    protected int length = 8;
    protected int slider = 1;
    private List<T> list = new ArrayList();
    private String orderBy = "";
    protected String funcName = "page";
    protected String funcParam = "";
    private String message = "";

    public Page() {
        this.pageSize = -1;
    }

    public Page(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, -2);
    }

    public Page(HttpServletRequest request, HttpServletResponse response, int defaultPageSize) {
        String no = request.getParameter("pageNo");
        if (StringUtils.isNumeric((CharSequence)no)) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"pageNo", (String)no);
            this.setPageNo(Integer.parseInt(no));
        } else if (request.getParameter("repage") != null && StringUtils.isNumeric((CharSequence)(no = CookieUtils.getCookie((HttpServletRequest)request, (String)"pageNo")))) {
            this.setPageNo(Integer.parseInt(no));
        }
        String size = request.getParameter("pageSize");
        if (StringUtils.isNumeric((CharSequence)size)) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"pageSize", (String)size);
            this.setPageSize(Integer.parseInt(size));
        } else if (request.getParameter("repage") != null) {
            no = CookieUtils.getCookie((HttpServletRequest)request, (String)"pageSize");
            if (StringUtils.isNumeric((CharSequence)size)) {
                this.setPageSize(Integer.parseInt(size));
            }
        } else if (defaultPageSize != -2) {
            this.pageSize = defaultPageSize;
        }
        String orderBy = request.getParameter("orderBy");
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            this.setOrderBy(orderBy);
        }
    }

    public Page(int pageNo, int pageSize) {
        this(pageNo, pageSize, 0L);
    }

    public Page(int pageNo, int pageSize, long count) {
        this(pageNo, pageSize, count, new ArrayList());
    }

    public Page(int pageNo, int pageSize, long count, List<T> list) {
        this.setCount(count);
        this.setPageNo(pageNo);
        this.pageSize = pageSize;
        this.list = list;
    }

    public void initialize() {
        this.first = 1;
        this.last = (int)(this.count / (long)(this.pageSize < 1 ? 20 : this.pageSize) + (long)this.first - 1L);
        if (this.count % (long)this.pageSize != 0L || this.last == 0) {
            ++this.last;
        }
        if (this.last < this.first) {
            this.last = this.first;
        }
        if (this.pageNo <= 1) {
            this.pageNo = this.first;
            this.firstPage = true;
        }
        if (this.pageNo >= this.last) {
            this.pageNo = this.last;
            this.lastPage = true;
        }
        this.next = this.pageNo < this.last - 1 ? this.pageNo + 1 : this.last;
        this.prev = this.pageNo > 1 ? this.pageNo - 1 : this.first;
        if (this.pageNo < this.first) {
            this.pageNo = this.first;
        }
        if (this.pageNo > this.last) {
            this.pageNo = this.last;
        }
    }

    public String toString() {
        int i;
        int end;
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"fixed-table-pagination\" style=\"display: block;\">");
        long startIndex = (this.pageNo - 1) * this.pageSize + 1;
        long endIndex = (long)(this.pageNo * this.pageSize) <= this.count ? (long)(this.pageNo * this.pageSize) : this.count;
        sb.append("<div class=\"pull-left pagination-detail\">");
        sb.append("<span class=\"pagination-info\">\u663e\u793a\u7b2c " + startIndex + " \u5230\u7b2c " + endIndex + " \u6761\u8bb0\u5f55\uff0c\u603b\u5171 " + this.count + " \u6761\u8bb0\u5f55</span>");
        sb.append("<span class=\"page-list\">\u6bcf\u9875\u663e\u793a <span class=\"btn-group dropup\">");
        sb.append("<button type=\"button\" class=\"btn btn-default  btn-outline dropdown-toggle\" data-toggle=\"dropdown\" aria-expanded=\"false\">");
        sb.append("<span class=\"page-size\">" + this.pageSize + "</span> <span class=\"caret\"></span>");
        sb.append("</button>");
        sb.append("<ul class=\"dropdown-menu\" role=\"menu\">");
        sb.append("<li class=\"" + this.getSelected(this.pageSize, 10) + "\"><a href=\"javascript:" + this.funcName + "(" + this.pageNo + ",10,'" + this.funcParam + "');\">10</a></li>");
        sb.append("<li class=\"" + this.getSelected(this.pageSize, 25) + "\"><a href=\"javascript:" + this.funcName + "(" + this.pageNo + ",25,'" + this.funcParam + "');\">25</a></li>");
        sb.append("<li class=\"" + this.getSelected(this.pageSize, 50) + "\"><a href=\"javascript:" + this.funcName + "(" + this.pageNo + ",50,'" + this.funcParam + "');\">50</a></li>");
        sb.append("<li class=\"" + this.getSelected(this.pageSize, 100) + "\"><a href=\"javascript:" + this.funcName + "(" + this.pageNo + ",100,'" + this.funcParam + "');\">100</a></li>");
        sb.append("</ul>");
        sb.append("</span> \u6761\u8bb0\u5f55</span>");
        sb.append("</div>");
        sb.append("<div class=\"pull-right pagination-roll\">");
        sb.append("<ul class=\"pagination pagination-outline\">");
        if (this.pageNo == this.first) {
            sb.append("<li class=\"paginate_button previous disabled\"><a href=\"javascript:\"><i class=\"fa fa-angle-double-left\"></i></a></li>\n");
            sb.append("<li class=\"paginate_button previous disabled\"><a href=\"javascript:\"><i class=\"fa fa-angle-left\"></i></a></li>\n");
        } else {
            sb.append("<li class=\"paginate_button previous\"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.first + "," + this.pageSize + ",'" + this.funcParam + "');\"><i class=\"fa fa-angle-double-left\"></i></a></li>\n");
            sb.append("<li class=\"paginate_button previous\"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.prev + "," + this.pageSize + ",'" + this.funcParam + "');\"><i class=\"fa fa-angle-left\"></i></a></li>\n");
        }
        int begin = this.pageNo - this.length / 2;
        if (begin < this.first) {
            begin = this.first;
        }
        if ((end = begin + this.length - 1) >= this.last && (begin = (end = this.last) - this.length + 1) < this.first) {
            begin = this.first;
        }
        if (begin > this.first) {
            i = 0;
            for (i = this.first; i < this.first + this.slider && i < begin; ++i) {
                sb.append("<li class=\"paginate_button \"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
            }
            if (i < begin) {
                sb.append("<li class=\"paginate_button disabled\"><a href=\"javascript:\">...</a></li>\n");
            }
        }
        for (i = begin; i <= end; ++i) {
            if (i == this.pageNo) {
                sb.append("<li class=\"paginate_button active\"><a href=\"javascript:\">" + (i + 1 - this.first) + "</a></li>\n");
                continue;
            }
            sb.append("<li class=\"paginate_button \"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.last - end > this.slider) {
            sb.append("<li class=\"paginate_button disabled\"><a href=\"javascript:\">...</a></li>\n");
            end = this.last - this.slider;
        }
        for (i = end + 1; i <= this.last; ++i) {
            sb.append("<li class=\"paginate_button \"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.pageNo == this.last) {
            sb.append("<li class=\"paginate_button next disabled\"><a href=\"javascript:\"><i class=\"fa fa-angle-right\"></i></a></li>\n");
            sb.append("<li class=\"paginate_button next disabled\"><a href=\"javascript:\"><i class=\"fa fa-angle-double-right\"></i></a></li>\n");
        } else {
            sb.append("<li class=\"paginate_button next\"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.next + "," + this.pageSize + ",'" + this.funcParam + "');\">" + "<i class=\"fa fa-angle-right\"></i></a></li>\n");
            sb.append("<li class=\"paginate_button next\"><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.last + "," + this.pageSize + ",'" + this.funcParam + "');\">" + "<i class=\"fa fa-angle-double-right\"></i></a></li>\n");
        }
        sb.append("</ul>");
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    protected String getSelected(int pageNo, int selectedPageNo) {
        if (pageNo == selectedPageNo) {
            return "active";
        }
        return "";
    }

    public String getHtml() {
        return this.toString();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
        if ((long)this.pageSize >= count) {
            this.pageNo = 1;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 10 : pageSize;
    }

    @JsonIgnore
    public int getFirst() {
        return this.first;
    }

    @JsonIgnore
    public int getLast() {
        return this.last;
    }

    @JsonIgnore
    public int getTotalPage() {
        return this.getLast();
    }

    @JsonIgnore
    public boolean isFirstPage() {
        return this.firstPage;
    }

    @JsonIgnore
    public boolean isLastPage() {
        return this.lastPage;
    }

    @JsonIgnore
    public int getPrev() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    @JsonIgnore
    public int getNext() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public List<T> getList() {
        return this.list;
    }

    public Page<T> setList(List<T> list) {
        this.list = list;
        this.initialize();
        return this;
    }

    @JsonIgnore
    public String getOrderBy() {
        String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
        Pattern sqlPattern = Pattern.compile(reg, 2);
        if (sqlPattern.matcher(this.orderBy).find()) {
            return "";
        }
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @JsonIgnore
    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    @JsonIgnore
    public String getFuncParam() {
        return this.funcParam;
    }

    public void setFuncParam(String funcParam) {
        this.funcParam = funcParam;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public boolean isDisabled() {
        return this.pageSize == -1;
    }

    @JsonIgnore
    public boolean isNotCount() {
        return this.count == -1L;
    }

    public int getFirstResult() {
        int firstResult = (this.getPageNo() - 1) * this.getPageSize();
        if ((long)firstResult >= this.getCount() || firstResult < 0) {
            firstResult = 0;
        }
        return firstResult;
    }

    public int getMaxResults() {
        return this.getPageSize();
    }
}

