/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.persistence.interceptor;

import com.jeeplus.common.config.Global;
import com.jeeplus.common.persistence.Page;
import com.jeeplus.common.persistence.dialect.Dialect;
import com.jeeplus.common.persistence.dialect.db.DB2Dialect;
import com.jeeplus.common.persistence.dialect.db.DerbyDialect;
import com.jeeplus.common.persistence.dialect.db.H2Dialect;
import com.jeeplus.common.persistence.dialect.db.HSQLDialect;
import com.jeeplus.common.persistence.dialect.db.MySQLDialect;
import com.jeeplus.common.persistence.dialect.db.OracleDialect;
import com.jeeplus.common.persistence.dialect.db.PostgreSQLDialect;
import com.jeeplus.common.persistence.dialect.db.SQLServer2005Dialect;
import com.jeeplus.common.persistence.dialect.db.SybaseDialect;
import com.jeeplus.common.utils.Reflections;
import java.io.Serializable;
import java.util.Properties;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Interceptor;

public abstract class BaseInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String PAGE = "page";
    protected static final String DELEGATE = "delegate";
    protected static final String MAPPED_STATEMENT = "mappedStatement";
    protected Log log = LogFactory.getLog(this.getClass());
    protected Dialect DIALECT;

    protected static Page<Object> convertParameter(Object parameterObject, Page<Object> page) {
        try {
            if (parameterObject instanceof Page) {
                return (Page)parameterObject;
            }
            return (Page)Reflections.getFieldValue((Object)parameterObject, (String)PAGE);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void initProperties(Properties p) {
        DB2Dialect dialect = null;
        String dbType = Global.getConfig((String)"jdbc.type");
        if ("db2".equals(dbType)) {
            dialect = new DB2Dialect();
        } else if ("derby".equals(dbType)) {
            dialect = new DerbyDialect();
        } else if ("h2".equals(dbType)) {
            dialect = new H2Dialect();
        } else if ("hsql".equals(dbType)) {
            dialect = new HSQLDialect();
        } else if ("mysql".equals(dbType)) {
            dialect = new MySQLDialect();
        } else if ("oracle".equals(dbType)) {
            dialect = new OracleDialect();
        } else if ("postgre".equals(dbType)) {
            dialect = new PostgreSQLDialect();
        } else if ("mssql".equals(dbType) || "sqlserver".equals(dbType)) {
            dialect = new SQLServer2005Dialect();
        } else if ("sybase".equals(dbType)) {
            dialect = new SybaseDialect();
        }
        if (dialect == null) {
            throw new RuntimeException("mybatis dialect error.");
        }
        this.DIALECT = dialect;
    }
}

