/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.persistence.interceptor;

import com.jeeplus.common.persistence.Page;
import com.jeeplus.common.persistence.dialect.Dialect;
import com.jeeplus.common.persistence.interceptor.BaseInterceptor;
import com.jeeplus.common.persistence.interceptor.PaginationInterceptor;
import com.jeeplus.common.persistence.interceptor.SQLHelper;
import com.jeeplus.common.utils.Reflections;
import com.jeeplus.common.utils.StringUtils;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

/*
 * Exception performing whole class analysis ignored.
 */
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
extends BaseInterceptor {
    private static final long serialVersionUID = 1L;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameter = invocation.getArgs()[1];
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        Object parameterObject = boundSql.getParameterObject();
        Page page = null;
        if (parameterObject != null) {
            page = PaginationInterceptor.convertParameter((Object)parameterObject, page);
        }
        if (page != null && page.getPageSize() != -1) {
            if (StringUtils.isBlank((CharSequence)boundSql.getSql())) {
                return null;
            }
            String originalSql = boundSql.getSql().trim();
            page.setCount((long)SQLHelper.getCount((String)originalSql, null, (MappedStatement)mappedStatement, (Object)parameterObject, (BoundSql)boundSql, (Log)this.log));
            String pageSql = SQLHelper.generatePageSql((String)originalSql, (Page)page, (Dialect)this.DIALECT);
            invocation.getArgs()[2] = new RowBounds(0, Integer.MAX_VALUE);
            BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), pageSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            if (Reflections.getFieldValue((Object)boundSql, (String)"metaParameters") != null) {
                MetaObject mo = (MetaObject)Reflections.getFieldValue((Object)boundSql, (String)"metaParameters");
                Reflections.setFieldValue((Object)newBoundSql, (String)"metaParameters", (Object)mo);
            }
            MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, (SqlSource)new BoundSqlSqlSource(newBoundSql));
            invocation.getArgs()[0] = newMs;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        super.initProperties(properties);
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null) {
            for (String keyProperty : ms.getKeyProperties()) {
                builder.keyProperty(keyProperty);
            }
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.cache(ms.getCache());
        return builder.build();
    }
}

