/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.security;

import com.jeeplus.common.utils.Encodes;
import com.jeeplus.common.utils.Exceptions;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class Cryptos {
    private static final String AES = "AES";
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final String HMACSHA1 = "HmacSHA1";
    private static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final int DEFAULT_HMACSHA1_KEYSIZE = 160;
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final int DEFAULT_IVSIZE = 16;
    private static final byte[] DEFAULT_KEY = new byte[]{-97, 88, -94, 9, 70, -76, 126, 25, 0, 3, -20, 113, 108, 28, 69, 125};
    private static SecureRandom random = new SecureRandom();

    public static byte[] hmacSha1(byte[] input, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            return mac.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static boolean isMacValid(byte[] expected, byte[] input, byte[] key) {
        byte[] actual = Cryptos.hmacSha1((byte[])input, (byte[])key);
        return Arrays.equals(expected, actual);
    }

    public static byte[] generateHmacSha1Key() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacSHA1");
            keyGenerator.init(160);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String aesEncrypt(String input) {
        try {
            return Encodes.encodeHex((byte[])Cryptos.aesEncrypt((byte[])input.getBytes("UTF-8"), (byte[])DEFAULT_KEY));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String aesEncrypt(String input, String key) {
        try {
            return Encodes.encodeHex((byte[])Cryptos.aesEncrypt((byte[])input.getBytes("UTF-8"), (byte[])Encodes.decodeHex((String)key)));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key) {
        return Cryptos.aes((byte[])input, (byte[])key, (int)1);
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, byte[] iv) {
        return Cryptos.aes((byte[])input, (byte[])key, (byte[])iv, (int)1);
    }

    public static String aesDecrypt(String input) {
        try {
            return new String(Cryptos.aesDecrypt((byte[])Encodes.decodeHex((String)input), (byte[])DEFAULT_KEY), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String aesDecrypt(String input, String key) {
        try {
            return new String(Cryptos.aesDecrypt((byte[])Encodes.decodeHex((String)input), (byte[])Encodes.decodeHex((String)key)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key) {
        return Cryptos.aes((byte[])input, (byte[])key, (int)2);
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key, byte[] iv) {
        return Cryptos.aes((byte[])input, (byte[])key, (byte[])iv, (int)2);
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String generateAesKeyString() {
        return Encodes.encodeHex((byte[])Cryptos.generateAesKey((int)128));
    }

    public static byte[] generateAesKey() {
        return Cryptos.generateAesKey((int)128);
    }

    public static byte[] generateAesKey(int keysize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(keysize);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static byte[] generateIV() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }
}

