/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.security;

import com.jeeplus.common.utils.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang3.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class Digests {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static SecureRandom random = new SecureRandom();

    public static byte[] md5(byte[] input) {
        return Digests.digest((byte[])input, (String)"MD5", null, (int)1);
    }

    public static byte[] md5(byte[] input, int iterations) {
        return Digests.digest((byte[])input, (String)"MD5", null, (int)iterations);
    }

    public static byte[] sha1(byte[] input) {
        return Digests.digest((byte[])input, (String)"SHA-1", null, (int)1);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return Digests.digest((byte[])input, (String)"SHA-1", (byte[])salt, (int)1);
    }

    public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
        return Digests.digest((byte[])input, (String)"SHA-1", (byte[])salt, (int)iterations);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static byte[] generateSalt(int numBytes) {
        Validate.isTrue((numBytes > 0 ? 1 : 0) != 0, (String)"numBytes argument must be a positive integer (1 or larger)", (long)numBytes);
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digests.digest((InputStream)input, (String)"MD5");
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digests.digest((InputStream)input, (String)"SHA-1");
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = input.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String string2MD5(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        char[] charArray = inStr.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
}

