/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.service;

import com.jeeplus.common.persistence.CrudDao;
import com.jeeplus.common.persistence.DataEntity;
import com.jeeplus.common.persistence.Page;
import com.jeeplus.common.service.BaseService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class CrudService<D extends CrudDao<T>, T extends DataEntity<T>>
extends BaseService {
    @Autowired
    protected D dao;

    public T get(String id) {
        return (T)((DataEntity)this.dao.get(id));
    }

    public T get(T entity) {
        return (T)((DataEntity)this.dao.get(entity));
    }

    public List<T> findList(T entity) {
        return this.dao.findList(entity);
    }

    public Page<T> findPage(Page<T> page, T entity) {
        entity.setPage(page);
        page.setList(this.dao.findList(entity));
        return page;
    }

    @Transactional(readOnly=false)
    public void save(T entity) {
        if (entity.getIsNewRecord()) {
            entity.preInsert();
            this.dao.insert(entity);
        } else {
            entity.preUpdate();
            this.dao.update(entity);
        }
    }

    @Transactional(readOnly=false)
    public void delete(T entity) {
        this.dao.delete(entity);
    }

    @Transactional(readOnly=false)
    public void deleteByLogic(T entity) {
        this.dao.deleteByLogic(entity);
    }

    @Transactional(readOnly=false)
    public void deleteAll(Collection<T> entitys) {
        for (DataEntity entity : entitys) {
            this.dao.delete((Object)entity);
        }
    }

    public T findUniqueByProperty(String propertyName, Object value) {
        return (T)((DataEntity)this.dao.findUniqueByProperty(propertyName, value));
    }
}

