/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.utils.ObjectUtils;
import com.jeeplus.common.utils.SpringContextHolder;
import com.jeeplus.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

/*
 * Exception performing whole class analysis ignored.
 */
public class JedisUtils {
    private static Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    private static JedisPool jedisPool = (JedisPool)SpringContextHolder.getBean(JedisPool.class);
    public static final String KEY_PREFIX = Global.getConfig((String)"redis.keyPrefix");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        String value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                value = jedis.get(key);
                value = StringUtils.isNotBlank((CharSequence)value) && !"nil".equalsIgnoreCase(value) ? value : null;
                logger.debug("get {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("get {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        Object value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                value = JedisUtils.toObject((byte[])jedis.get(JedisUtils.getBytesKey((Object)key)));
                logger.debug("getObject {} = {}", (Object)key, value);
            }
        }
        catch (Exception e) {
            logger.warn("getObject {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String set(String key, String value, int cacheSeconds) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.set(key, value);
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("set {} = {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            logger.warn("set {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int cacheSeconds) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.set(JedisUtils.getBytesKey((Object)key), JedisUtils.toBytes((Object)value));
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setObject {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setObject {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String key) {
        List value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                value = jedis.lrange(key, 0L, -1L);
                logger.debug("getList {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getList {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getObjectList(String key) {
        ArrayList value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                List list = jedis.lrange(JedisUtils.getBytesKey((Object)key), 0L, -1L);
                value = Lists.newArrayList();
                for (byte[] bs : list) {
                    value.add(JedisUtils.toObject((byte[])bs));
                }
                logger.debug("getObjectList {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getObjectList {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setList(String key, List<String> value, int cacheSeconds) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                jedis.del(key);
            }
            result = jedis.rpush(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setList {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setList {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectList(String key, List<Object> value, int cacheSeconds) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                jedis.del(key);
            }
            ArrayList list = Lists.newArrayList();
            for (Object o : value) {
                list.add(JedisUtils.toBytes((Object)o));
            }
            result = jedis.rpush(JedisUtils.getBytesKey((Object)key), (byte[][])list.toArray());
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setObjectList {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setObjectList {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listAdd(String key, String ... value) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.rpush(key, value);
            logger.debug("listAdd {} = {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            logger.warn("listAdd {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listObjectAdd(String key, Object ... value) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            ArrayList list = Lists.newArrayList();
            for (Object o : value) {
                list.add(JedisUtils.toBytes((Object)o));
            }
            result = jedis.rpush(JedisUtils.getBytesKey((Object)key), (byte[][])list.toArray());
            logger.debug("listObjectAdd {} = {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            logger.warn("listObjectAdd {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String key) {
        Set value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                value = jedis.smembers(key);
                logger.debug("getSet {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getSet {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Object> getObjectSet(String key) {
        HashSet value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                value = Sets.newHashSet();
                Set set = jedis.smembers(JedisUtils.getBytesKey((Object)key));
                for (byte[] bs : set) {
                    value.add(JedisUtils.toObject((byte[])bs));
                }
                logger.debug("getObjectSet {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getObjectSet {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSet(String key, Set<String> value, int cacheSeconds) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                jedis.del(key);
            }
            result = jedis.sadd(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setSet {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setSet {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectSet(String key, Set<Object> value, int cacheSeconds) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                jedis.del(key);
            }
            HashSet set = Sets.newHashSet();
            for (Object o : value) {
                set.add(JedisUtils.toBytes((Object)o));
            }
            result = jedis.sadd(JedisUtils.getBytesKey((Object)key), (byte[][])set.toArray());
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setObjectSet {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setObjectSet {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetAdd(String key, String ... value) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.sadd(key, value);
            logger.debug("setSetAdd {} = {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            logger.warn("setSetAdd {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetObjectAdd(String key, Object ... value) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            HashSet set = Sets.newHashSet();
            for (Object o : value) {
                set.add(JedisUtils.toBytes((Object)o));
            }
            result = jedis.rpush(JedisUtils.getBytesKey((Object)key), (byte[][])set.toArray());
            logger.debug("setSetObjectAdd {} = {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            logger.warn("setSetObjectAdd {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String key) {
        Map value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                value = jedis.hgetAll(key);
                logger.debug("getMap {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getMap {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getObjectMap(String key) {
        HashMap value = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                value = Maps.newHashMap();
                Map map = jedis.hgetAll(JedisUtils.getBytesKey((Object)key));
                for (Map.Entry e : map.entrySet()) {
                    value.put(StringUtils.toString((byte[])((byte[])e.getKey())), JedisUtils.toObject((byte[])((byte[])e.getValue())));
                }
                logger.debug("getObjectMap {} = {}", (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            logger.warn("getObjectMap {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setMap(String key, Map<String, String> value, int cacheSeconds) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                jedis.del(key);
            }
            result = jedis.hmset(key, value);
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setMap {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setMap {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObjectMap(String key, Map<String, Object> value, int cacheSeconds) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                jedis.del(key);
            }
            HashMap map = Maps.newHashMap();
            for (Map.Entry<String, Object> e : value.entrySet()) {
                map.put(JedisUtils.getBytesKey((Object)e.getKey()), JedisUtils.toBytes((Object)e.getValue()));
            }
            result = jedis.hmset(JedisUtils.getBytesKey((Object)key), (Map)map);
            if (cacheSeconds != 0) {
                jedis.expire(key, cacheSeconds);
            }
            logger.debug("setObjectMap {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("setObjectMap {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapPut(String key, Map<String, String> value) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.hmset(key, value);
            logger.debug("mapPut {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("mapPut {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapObjectPut(String key, Map<String, Object> value) {
        String result = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            HashMap map = Maps.newHashMap();
            for (Map.Entry<String, Object> e : value.entrySet()) {
                map.put(JedisUtils.getBytesKey((Object)e.getKey()), JedisUtils.toBytes((Object)e.getValue()));
            }
            result = jedis.hmset(JedisUtils.getBytesKey((Object)key), (Map)map);
            logger.debug("mapObjectPut {} = {}", (Object)key, value);
        }
        catch (Exception e) {
            logger.warn("mapObjectPut {} = {}", new Object[]{key, value, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapRemove(String key, String mapKey) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.hdel(key, new String[]{mapKey});
            logger.debug("mapRemove {}  {}", (Object)key, (Object)mapKey);
        }
        catch (Exception e) {
            logger.warn("mapRemove {}  {}", new Object[]{key, mapKey, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapObjectRemove(String key, String mapKey) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.hdel(JedisUtils.getBytesKey((Object)key), (byte[][])new byte[][]{JedisUtils.getBytesKey((Object)mapKey)});
            logger.debug("mapObjectRemove {}  {}", (Object)key, (Object)mapKey);
        }
        catch (Exception e) {
            logger.warn("mapObjectRemove {}  {}", new Object[]{key, mapKey, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapExists(String key, String mapKey) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.hexists(key, mapKey);
            logger.debug("mapExists {}  {}", (Object)key, (Object)mapKey);
        }
        catch (Exception e) {
            logger.warn("mapExists {}  {}", new Object[]{key, mapKey, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapObjectExists(String key, String mapKey) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.hexists(JedisUtils.getBytesKey((Object)key), JedisUtils.getBytesKey((Object)mapKey));
            logger.debug("mapObjectExists {}  {}", (Object)key, (Object)mapKey);
        }
        catch (Exception e) {
            logger.warn("mapObjectExists {}  {}", new Object[]{key, mapKey, e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long del(String key) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(key).booleanValue()) {
                result = jedis.del(key);
                logger.debug("del {}", (Object)key);
            } else {
                logger.debug("del {} not exists", (Object)key);
            }
        }
        catch (Exception e) {
            logger.warn("del {}", (Object)key, (Object)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long delObject(String key) {
        long result = 0L;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            if (jedis.exists(JedisUtils.getBytesKey((Object)key)).booleanValue()) {
                result = jedis.del(JedisUtils.getBytesKey((Object)key));
                logger.debug("delObject {}", (Object)key);
            } else {
                logger.debug("delObject {} not exists", (Object)key);
            }
        }
        catch (Exception e) {
            logger.warn("delObject {}", (Object)key, (Object)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String key) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.exists(key);
            logger.debug("exists {}", (Object)key);
        }
        catch (Exception e) {
            logger.warn("exists {}", (Object)key, (Object)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsObject(String key) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            result = jedis.exists(JedisUtils.getBytesKey((Object)key));
            logger.debug("existsObject {}", (Object)key);
        }
        catch (Exception e) {
            logger.warn("existsObject {}", (Object)key, (Object)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return result;
    }

    public static Jedis getResource() throws JedisException {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
        }
        catch (JedisException e) {
            logger.warn("getResource.", (Throwable)e);
            JedisUtils.returnBrokenResource((Jedis)jedis);
            throw e;
        }
        return jedis;
    }

    public static void returnBrokenResource(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnBrokenResource(jedis);
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

    public static byte[] getBytesKey(Object object) {
        if (object instanceof String) {
            return StringUtils.getBytes((String)((String)object));
        }
        return ObjectUtils.serialize((Object)object);
    }

    public static byte[] toBytes(Object object) {
        return ObjectUtils.serialize((Object)object);
    }

    public static Object toObject(byte[] bytes) {
        return ObjectUtils.unserialize((byte[])bytes);
    }
}

