/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class Reflections {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Logger logger = LoggerFactory.getLogger(Reflections.class);

    public static Object invokeGetter(Object obj, String propertyName) {
        Object object = obj;
        for (String name : StringUtils.split((String)propertyName, (String)".")) {
            String getterMethodName = "get" + StringUtils.capitalize((String)name);
            object = Reflections.invokeMethod((Object)object, (String)getterMethodName, (Class[])new Class[0], (Object[])new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Object object = obj;
        String[] names = StringUtils.split((String)propertyName, (String)".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = "get" + StringUtils.capitalize((String)names[i]);
                object = Reflections.invokeMethod((Object)object, (String)getterMethodName, (Class[])new Class[0], (Object[])new Object[0]);
                continue;
            }
            String setterMethodName = "set" + StringUtils.capitalize((String)names[i]);
            Reflections.invokeMethodByName((Object)object, (String)setterMethodName, (Object[])new Object[]{value});
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = Reflections.getAccessibleField((Object)obj, (String)fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = Reflections.getAccessibleField((Object)obj, (String)fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = Reflections.getAccessibleMethod((Object)obj, (String)methodName, (Class[])parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Reflections.convertReflectionExceptionToUnchecked((Exception)e);
        }
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = Reflections.getAccessibleMethodByName((Object)obj, (String)methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Reflections.convertReflectionExceptionToUnchecked((Exception)e);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                Reflections.makeAccessible((Field)field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                Reflections.makeAccessible((Method)method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Reflections.makeAccessible((Method)method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return Reflections.getClassGenricType((Class)clazz, (int)0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains("$$") && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }
}

