/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common.xstream;

import com.jeeplus.common.utils.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Date;

public class DateTimeConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Date date = (Date)source;
        if (date != null) {
            writer.setValue(DateUtils.formatDateTime((Date)date));
        } else {
            writer.setValue("");
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            Date date = DateUtils.parseDate((Object)reader.getValue());
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }
}

